/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.network.messages;

import com.vulp.tomes.network.messages.IMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class ServerSyncPersistentDataMessage
implements IMessage<ServerSyncPersistentDataMessage> {
    private CompoundNBT nbt;
    private int entityID;

    public ServerSyncPersistentDataMessage() {
    }

    public ServerSyncPersistentDataMessage(CompoundNBT nbt, int entityID) {
        this.nbt = nbt;
        this.entityID = entityID;
    }

    @Override
    public void encode(ServerSyncPersistentDataMessage message, PacketBuffer buffer) {
        buffer.func_150786_a(message.nbt);
        buffer.writeInt(message.entityID);
    }

    @Override
    public ServerSyncPersistentDataMessage decode(PacketBuffer buffer) {
        return new ServerSyncPersistentDataMessage(buffer.func_150793_b(), buffer.readInt());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(ServerSyncPersistentDataMessage message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            World world;
            Entity entity;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && (entity = (world = player.func_130014_f_()).func_73045_a(message.entityID)) != null) {
                entity.getPersistentData().func_197643_a(message.nbt.func_74737_b());
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

