/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.spells.active;

import com.google.common.collect.ImmutableSet;
import com.vulp.tomes.config.TomesConfig;
import com.vulp.tomes.entities.TamedSpiderEntity;
import com.vulp.tomes.init.EntityInit;
import com.vulp.tomes.network.TomesPacketHandler;
import com.vulp.tomes.network.messages.ServerTameAnimalMessage;
import com.vulp.tomes.spells.active.ActiveSpell;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.network.PacketDistributor;

public class BeastTamerSpell
extends ActiveSpell {
    private static final ImmutableSet<Class<? extends LivingEntity>> tameableMobs = ImmutableSet.of(WolfEntity.class, CatEntity.class, ParrotEntity.class, FoxEntity.class, HorseEntity.class, SkeletonHorseEntity.class, (Object[])new Class[]{ZombieHorseEntity.class, DonkeyEntity.class, LlamaEntity.class, MuleEntity.class, SpiderEntity.class});

    public BeastTamerSpell(Enchantment.Rarity rarity, boolean isActive, boolean isRare, ForgeConfigSpec.ConfigValue<Boolean> enabled) {
        super(rarity, isActive, isRare, enabled);
    }

    @Override
    public int getSpellCost() {
        return (Integer)TomesConfig.beast_tamer_cost.get();
    }

    @Override
    public boolean onCast(World worldIn, PlayerEntity playerIn, Hand handIn) {
        LivingEntity target = (LivingEntity)this.getTarget();
        boolean flag = false;
        if (target != null) {
            for (Class mob : tameableMobs) {
                if (mob != target.getClass()) continue;
                flag = true;
                if (target instanceof TameableEntity && !((TameableEntity)target).func_70909_n()) {
                    ((TameableEntity)target).func_193101_c(playerIn);
                    continue;
                }
                if (target instanceof FoxEntity) {
                    ((FoxEntity)target).func_213465_b(playerIn.func_110124_au());
                    if (!worldIn.field_72995_K) continue;
                    BeastTamerSpell.tameEffect((Entity)target);
                    continue;
                }
                if (target instanceof AbstractHorseEntity && !((AbstractHorseEntity)target).func_110248_bS()) {
                    ((AbstractHorseEntity)target).func_110263_g(playerIn);
                    continue;
                }
                if (target instanceof SpiderEntity) {
                    if (worldIn.field_72995_K) continue;
                    CompoundNBT nbt = target.serializeNBT();
                    float pitch = target.field_70125_A;
                    float yaw = target.field_70177_z;
                    float yawHead = target.field_70759_as;
                    ITextComponent name = target.func_200201_e();
                    TamedSpiderEntity tamedEntity = (TamedSpiderEntity)EntityInit.tamed_spider.func_220342_a((ServerWorld)worldIn, nbt, name, playerIn, target.func_233580_cy_(), SpawnReason.CONVERSION, false, false);
                    if (tamedEntity == null) continue;
                    target.func_70106_y();
                    tamedEntity.field_70125_A = pitch;
                    tamedEntity.field_70177_z = yaw;
                    tamedEntity.field_70759_as = yawHead;
                    tamedEntity.func_193101_c(playerIn);
                    continue;
                }
                flag = false;
            }
        }
        this.setTarget(null);
        return flag;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void tameEffect(Entity entity) {
        Vector3d vec = entity.func_213303_ch();
        TomesPacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ServerTameAnimalMessage(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, entity.func_213311_cf(), entity.func_213302_cg()));
    }

    @Override
    public int getCooldown() {
        return (Integer)TomesConfig.beast_tamer_cooldown.get();
    }

    @Override
    public boolean canTick() {
        return false;
    }

    @Override
    public void tick(World world, Entity playerIn) {
    }
}

