/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.spells.active;

import com.vulp.tomes.config.TomesConfig;
import com.vulp.tomes.init.ParticleInit;
import com.vulp.tomes.spells.active.ActiveSpell;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class LifebringerSpell
extends ActiveSpell {
    private int timer = 0;
    private Vector3d playerPos;

    public LifebringerSpell(Enchantment.Rarity rarity, boolean isActive, boolean isRare, ForgeConfigSpec.ConfigValue<Boolean> enabled) {
        super(rarity, isActive, isRare, enabled);
    }

    @Override
    public int getSpellCost() {
        return (Integer)TomesConfig.lifebringer_cost.get();
    }

    @Override
    public boolean onCast(World worldIn, PlayerEntity playerIn, Hand handIn) {
        BlockPos playerPos = playerIn.func_233580_cy_();
        if (!worldIn.field_72995_K) {
            for (int x = 0; x < 7; ++x) {
                for (int z = 0; z < 7; ++z) {
                    for (int y = 0; y < 7; ++y) {
                        BlockPos pos = playerPos.func_177982_a(x - 3, y - 3, z - 3);
                        BlockState state = worldIn.func_180495_p(pos);
                        if (!(state.func_177230_c() instanceof IGrowable)) continue;
                        ((IGrowable)state.func_177230_c()).func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, pos, state);
                    }
                }
            }
            List list = worldIn.func_175647_a(AnimalEntity.class, new AxisAlignedBB(playerPos.func_177982_a(-3, -3, -3), playerPos.func_177982_a(3, 3, 3)), animalEntity -> !animalEntity.func_70631_g_());
            for (AnimalEntity animal : list) {
                if (!animal.func_204701_dC()) continue;
                animal.func_146082_f(playerIn);
            }
        } else {
            this.timer = 30;
            this.playerPos = playerIn.func_213303_ch();
        }
        return true;
    }

    @Override
    public int getCooldown() {
        return (Integer)TomesConfig.lifebringer_cooldown.get();
    }

    @Override
    public boolean canTick() {
        return true;
    }

    @Override
    public void tick(World world, Entity entity) {
        if (world.field_72995_K) {
            if (this.timer > 0 && this.timer % 5 == 0) {
                for (int i = 0; i < 8; ++i) {
                    Random rand = new Random();
                    float j = (rand.nextFloat() - 0.5f) * 0.5f;
                    float k = (rand.nextFloat() - 0.5f) * 0.5f;
                    float l = (rand.nextFloat() - 0.5f) * 0.5f;
                    world.func_195594_a((IParticleData)ParticleInit.living_wisp, this.playerPos.field_72450_a + (double)(rand.nextFloat() * 7.0f) - 3.5, this.playerPos.field_72448_b + (double)(rand.nextFloat() * 7.0f) - 3.5, this.playerPos.field_72449_c + (double)(rand.nextFloat() * 7.0f) - 3.5, (double)j, (double)k, (double)l);
                }
            }
            --this.timer;
        }
    }
}

