/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.spells.active;

import com.vulp.tomes.config.TomesConfig;
import com.vulp.tomes.init.TagInit;
import com.vulp.tomes.spells.active.ActiveSpell;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class MoldingLandsSpell
extends ActiveSpell {
    public MoldingLandsSpell(Enchantment.Rarity rarity, boolean isActive, boolean isRare, ForgeConfigSpec.ConfigValue<Boolean> enabled) {
        super(rarity, isActive, isRare, enabled);
    }

    @Override
    public int getSpellCost() {
        return (Integer)TomesConfig.molding_lands_cost.get();
    }

    @Override
    public boolean onCast(World worldIn, PlayerEntity playerIn, Hand handIn) {
        int r = 6;
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos playerPos = playerIn.func_233580_cy_();
        boolean success = false;
        for (int tx = -r; tx < r + 1; ++tx) {
            for (int ty = -r; ty < r + 1; ++ty) {
                for (int tz = -r; tz < r + 1; ++tz) {
                    BlockState state;
                    if (!(Math.sqrt(Math.pow(tx, 2.0) + Math.pow(ty, 2.0) + Math.pow(tz, 2.0)) <= (double)(r - 2))) continue;
                    BlockPos pos = new BlockPos(tx + playerPos.func_177958_n(), ty + playerPos.func_177956_o(), tz + playerPos.func_177952_p());
                    list.add(pos);
                    if (!worldIn.field_72995_K || (!(state = worldIn.func_180495_p(pos)).func_235714_a_(TagInit.GRASS) || state.func_177230_c() == Blocks.field_150391_bh) && !state.func_235714_a_((ITag)BlockTags.field_200031_h) && !state.func_235714_a_((ITag)BlockTags.field_206952_E)) continue;
                    success = true;
                }
            }
        }
        Random rand = new Random();
        if (!worldIn.field_72995_K) {
            boolean mush = rand.nextBoolean();
            boolean[] flag = new boolean[]{false};
            for (BlockPos pos : list) {
                if (worldIn.func_180495_p(pos).func_177230_c() instanceof GrassBlock) {
                    worldIn.func_175656_a(pos, Blocks.field_150391_bh.func_176223_P());
                    if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof AirBlock && rand.nextInt(20) == 0) {
                        if (rand.nextBoolean()) {
                            worldIn.func_175656_a(pos.func_177984_a(), Blocks.field_150337_Q.func_176223_P());
                        } else {
                            worldIn.func_175656_a(pos.func_177984_a(), Blocks.field_150338_P.func_176223_P());
                        }
                    }
                    flag[0] = true;
                    continue;
                }
                if (worldIn.func_180495_p(pos).func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h)) {
                    worldIn.func_175656_a(pos, Blocks.field_196706_do.func_176223_P());
                    flag[0] = true;
                    continue;
                }
                if (!(worldIn.func_180495_p(pos).func_177230_c() instanceof LeavesBlock)) continue;
                if (mush) {
                    worldIn.func_175656_a(pos, Blocks.field_150420_aW.func_176223_P());
                } else {
                    worldIn.func_175656_a(pos, Blocks.field_150419_aX.func_176223_P());
                }
                flag[0] = true;
            }
            worldIn.func_175647_a(CowEntity.class, new AxisAlignedBB(playerPos.func_177982_a(-3, -3, -3), playerPos.func_177982_a(3, 3, 3)), e -> !(e instanceof MooshroomEntity)).forEach(e -> {
                EntityType.field_200780_T.func_220342_a((ServerWorld)worldIn, e.serializeNBT(), e.func_200201_e(), playerIn, e.func_233580_cy_(), SpawnReason.CONVERSION, false, false);
                e.func_70106_y();
                flag[0] = true;
            });
            return flag[0];
        }
        if (success) {
            for (BlockPos pos : list) {
                for (int i = 0; i < 2; ++i) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197596_G, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat()), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int getCooldown() {
        return (Integer)TomesConfig.molding_lands_cooldown.get();
    }

    @Override
    public boolean canTick() {
        return false;
    }

    @Override
    public void tick(World world, Entity entity) {
    }
}

