/*
 * Decompiled with CFR 0.152.
 */
package wildberries.block;

import java.util.Random;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wildberries.init.WildberriesModBlocks;
import wildberries.init.WildberriesModItems;
import wildberries.procedures.CranberryGrowingProcedure;
import wildberries.procedures.CranberryHarvestProcedure;
import wildberries.procedures.ResetFallDamageProcedure;

public class CranberryBushStage0Block
extends FlowerBlock {
    public CranberryBushStage0Block() {
        super(MobEffects.f_19596_, 100, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60977_().m_60918_(SoundType.f_56757_).m_60966_().m_60956_(0.34f).m_60967_(0.34f).m_60910_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(world, pos);
        return CranberryBushStage0Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public int m_53522_() {
        return 100;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)WildberriesModItems.CRANBERRIES.get());
    }

    public void m_7458_(BlockState blockstate, ServerLevel world, BlockPos pos, Random random) {
        super.m_7458_(blockstate, world, pos, random);
        CranberryGrowingProcedure.execute((LevelAccessor)world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public void m_7892_(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(blockstate, world, pos, entity);
        ResetFallDamageProcedure.execute(entity);
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult hit) {
        super.m_6227_(blockstate, world, pos, entity, hand, hit);
        CranberryHarvestProcedure.execute((LevelAccessor)world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), (Entity)entity);
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderLayer() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)WildberriesModBlocks.CRANBERRY_BUSH_STAGE_0.get()), renderType -> renderType == RenderType.m_110463_());
    }
}

