/*
 * Decompiled with CFR 0.152.
 */
package wildberries.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import wildberries.world.features.plants.BlackberryBushStage3Feature;
import wildberries.world.features.plants.BlueberryBushStage3Feature;
import wildberries.world.features.plants.CranberryBushStage3Feature;
import wildberries.world.features.plants.RaspberryBushStage3Feature;

@Mod.EventBusSubscriber
public class WildberriesModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"wildberries");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> BLUEBERRY_BUSH_STAGE_3 = WildberriesModFeatures.register("blueberry_bush_stage_3", BlueberryBushStage3Feature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, BlueberryBushStage3Feature.GENERATE_BIOMES, BlueberryBushStage3Feature::placedFeature));
    public static final RegistryObject<Feature<?>> RASPBERRY_BUSH_STAGE_3 = WildberriesModFeatures.register("raspberry_bush_stage_3", RaspberryBushStage3Feature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, RaspberryBushStage3Feature.GENERATE_BIOMES, RaspberryBushStage3Feature::placedFeature));
    public static final RegistryObject<Feature<?>> BLACKBERRY_BUSH_STAGE_3 = WildberriesModFeatures.register("blackberry_bush_stage_3", BlackberryBushStage3Feature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, BlackberryBushStage3Feature.GENERATE_BIOMES, BlackberryBushStage3Feature::placedFeature));
    public static final RegistryObject<Feature<?>> CRANBERRY_BUSH_STAGE_3 = WildberriesModFeatures.register("cranberry_bush_stage_3", CranberryBushStage3Feature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, CranberryBushStage3Feature.GENERATE_BIOMES, CranberryBushStage3Feature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

