/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination;

import com.github.x3rmination.core.config.X3DUNGEONSConfig;
import com.github.x3rmination.core.event.X3DUNGEONSEvents;
import com.github.x3rmination.core.registry.EnchantmentInit;
import com.github.x3rmination.core.registry.EntityInit;
import com.github.x3rmination.core.registry.ItemInit;
import com.github.x3rmination.core.registry.StructureFeatureInit;
import com.github.x3rmination.core.registry.StructureInit;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="x3dungeons")
public class X3DUNGEONS {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "x3dungeons";
    private static Method GETCODEC_METHOD;

    public X3DUNGEONS() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::processIMC);
        ItemInit.ITEMS.register(modEventBus);
        ItemInit.ARTIFACTS.register(modEventBus);
        EntityInit.ENTITIES.register(modEventBus);
        EnchantmentInit.ENCHANTMENTS.register(modEventBus);
        StructureInit.STRUCTURES.register(modEventBus);
        forgeBus.register((Object)this);
        forgeBus.register((Object)new X3DUNGEONSEvents());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, X3DUNGEONSConfig.SPEC, "x3dungeons-common.toml");
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
    }

    private void setup(FMLCommonSetupEvent event) {
        StructureFeatureInit.registerConfiguredStructures();
        event.enqueueWork(() -> {
            StructureInit.setupStructures();
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)EntityInit.GLADIATOR_SKELETON.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        });
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CURIO.getMessageBuilder().size(4).build());
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    public void biomeModification(BiomeLoadingEvent event) {
        if ((event.getCategory() == Biome.Category.JUNGLE || event.getCategory() == Biome.Category.ICY) && (double)event.getScale() < 0.5) {
            event.getGeneration().getStructures().add(() -> StructureFeatureInit.CONFIGURED_SWAG_DRAGON);
        }
        if ((double)event.getScale() < 0.5) {
            event.getGeneration().getStructures().add(() -> StructureFeatureInit.CONFIGURED_PIGLIN_CAMP);
        }
        if (event.getCategory() == Biome.Category.NETHER) {
            event.getGeneration().getStructures().add(() -> StructureFeatureInit.CONFIGURED_PIGLIN_FORGE);
        }
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(StructureInit.SWAG_DRAGON.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.SWAG_DRAGON.get()));
            tempMap.putIfAbsent(StructureInit.ZOMBIE_DUNGEON.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.ZOMBIE_DUNGEON.get()));
            tempMap.putIfAbsent(StructureInit.PIGLIN_CAMP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.PIGLIN_CAMP.get()));
            tempMap.putIfAbsent(StructureInit.PIGLIN_FORGE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)StructureInit.PIGLIN_FORGE.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

