/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination.common.entities.AncientSkeleton;

import com.github.x3rmination.common.entities.SweepProjectile.SweepProjectileEntity;
import com.github.x3rmination.core.registry.ItemInit;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class AncientSkeletonEntity
extends MonsterEntity
implements IAnimatable {
    private final AnimationFactory animationFactory = new AnimationFactory((IAnimatable)this);
    private final ServerBossInfo bossEvent = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private static final DataParameter<Boolean> PERFORM_ATTACK_0_ANIM = EntityDataManager.func_187226_a(AncientSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PERFORM_ATTACK_1_ANIM = EntityDataManager.func_187226_a(AncientSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PERFORM_ATTACK_2_ANIM = EntityDataManager.func_187226_a(AncientSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public AncientSkeletonEntity(EntityType<? extends AncientSkeletonEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 120.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233820_c_, 10.0).func_233815_a_(Attributes.field_233823_f_, 10.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AncientSkeletonGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected void func_180481_a(DifficultyInstance pDifficulty) {
        ItemStack chestStack = new ItemStack((IItemProvider)Items.field_151163_ad);
        chestStack.func_77966_a(Enchantments.field_180308_g, 4);
        ItemStack legStack = new ItemStack((IItemProvider)Items.field_151173_ae);
        legStack.func_77966_a(Enchantments.field_180308_g, 4);
        ItemStack bootStack = new ItemStack((IItemProvider)Items.field_151175_af);
        bootStack.func_77966_a(Enchantments.field_180308_g, 4);
        this.func_184201_a(EquipmentSlotType.CHEST, chestStack);
        this.func_184201_a(EquipmentSlotType.LEGS, legStack);
        this.func_184201_a(EquipmentSlotType.FEET, bootStack);
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ItemInit.ANCIENT_SWORD.get()));
        this.func_184642_a(EquipmentSlotType.MAINHAND, 2.0f);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld pLevel, DifficultyInstance pDifficulty, SpawnReason pReason, @Nullable ILivingEntityData pSpawnData, @Nullable CompoundNBT pDataTag) {
        pSpawnData = super.func_213386_a(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.func_180481_a(pDifficulty);
        this.func_98053_h(false);
        return pSpawnData;
    }

    public boolean func_70097_a(DamageSource pSource, float pAmount) {
        if (pSource.func_76352_a()) {
            pAmount *= 0.5f;
        }
        return super.func_70097_a(pSource, pAmount);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (Boolean.TRUE.equals(this.field_70180_af.func_187225_a(PERFORM_ATTACK_0_ANIM))) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ancient_skeleton.attack0", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (Boolean.TRUE.equals(this.field_70180_af.func_187225_a(PERFORM_ATTACK_1_ANIM))) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ancient_skeleton.attack1", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (Boolean.TRUE.equals(this.field_70180_af.func_187225_a(PERFORM_ATTACK_2_ANIM))) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ancient_skeleton.attack2", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ancient_skeleton.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ancient_skeleton.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_70619_bc() {
        this.bossEvent.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        super.func_70619_bc();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (((Boolean)this.field_70180_af.func_187225_a(PERFORM_ATTACK_0_ANIM)).equals(Boolean.TRUE) || ((Boolean)this.field_70180_af.func_187225_a(PERFORM_ATTACK_1_ANIM)).equals(Boolean.TRUE) || ((Boolean)this.field_70180_af.func_187225_a(PERFORM_ATTACK_2_ANIM)).equals(Boolean.TRUE)) {
            this.func_213293_j(0.0, 0.0, 0.0);
        }
    }

    private void spawnAttack1Particles(ServerWorld serverWorld) {
        for (int i = 1; i < 8; ++i) {
            double xModifier = Math.sin((double)i * Math.PI / 4.0);
            double zModifier = Math.cos((double)i * Math.PI / 4.0);
            for (int j = 0; j < 4; ++j) {
                serverWorld.func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.func_233568_aJ_()), this.func_226277_ct_() + xModifier + (double)j, this.func_226278_cu_() + 0.2, this.func_226281_cx_() + zModifier + (double)j, 10, 1.0, 1.0, 1.0, 1.0);
            }
        }
    }

    public void func_184178_b(ServerPlayerEntity pServerPlayer) {
        super.func_184178_b(pServerPlayer);
        this.bossEvent.func_186760_a(pServerPlayer);
    }

    public void func_184203_c(ServerPlayerEntity pServerPlayer) {
        super.func_184203_c(pServerPlayer);
        this.bossEvent.func_186761_b(pServerPlayer);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PERFORM_ATTACK_0_ANIM, (Object)false);
        this.field_70180_af.func_187214_a(PERFORM_ATTACK_1_ANIM, (Object)false);
        this.field_70180_af.func_187214_a(PERFORM_ATTACK_2_ANIM, (Object)false);
    }

    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_225511_J_()) {
            this.func_70106_y();
        } else {
            this.field_70708_bq = 0;
        }
    }

    public class AncientSkeletonGoal
    extends Goal {
        private final AncientSkeletonEntity entity;
        private int pathDelay = 0;
        private int cdAttack0 = 0;
        private int cdAttack1 = 0;
        private int cdAttack2 = 0;
        private int cdMove0 = 0;
        private int executionId = -1;
        private int executionDelay = 0;
        private int nextAttackDelay = 0;
        private double distanceToTarget;

        public AncientSkeletonGoal(AncientSkeletonEntity entity) {
            this.entity = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity target = this.entity.func_70638_az();
            return target != null && target.func_70089_S();
        }

        public void func_75249_e() {
            this.followTarget();
        }

        public void func_75251_c() {
            this.entity.func_70661_as().func_188554_j();
        }

        public void func_75246_d() {
            LivingEntity target = this.entity.func_70638_az();
            if (target == null || target.func_233643_dh_() || this.entity.field_70170_p == null) {
                return;
            }
            this.distanceToTarget = this.entity.func_70068_e((Entity)target);
            this.decreaseCoolDowns();
            this.entity.field_70749_g.func_75651_a((Entity)target, 30.0f, 30.0f);
            if (this.executionId == -1 && --this.nextAttackDelay < 1) {
                this.queueAttack();
            } else if (--this.executionDelay < 1) {
                this.performAttack();
            }
            if (--this.pathDelay < 1) {
                this.followTarget();
                this.pathDelay = 15;
            }
        }

        private void decreaseCoolDowns() {
            --this.cdAttack0;
            --this.cdAttack1;
            --this.cdAttack2;
            --this.cdMove0;
        }

        private void followTarget() {
            if (this.entity.func_70638_az() != null && this.executionId == -1) {
                this.entity.func_70661_as().func_75497_a((Entity)this.entity.func_70638_az(), 1.0);
            }
        }

        private void queueAttack() {
            if (this.distanceToTarget < 4.0 && this.cdAttack0 < 1) {
                this.executionDelay = 28;
                this.executionId = 0;
                this.entity.field_70180_af.func_187227_b(PERFORM_ATTACK_0_ANIM, (Object)true);
                this.entity.func_70661_as().func_75499_g();
            } else if (this.distanceToTarget < 7.0 && this.cdAttack1 < 1) {
                this.executionDelay = 32;
                this.executionId = 1;
                this.entity.field_70180_af.func_187227_b(PERFORM_ATTACK_1_ANIM, (Object)true);
                this.entity.func_70661_as().func_75499_g();
            } else if (this.distanceToTarget > 8.0 && this.cdAttack2 < 1) {
                this.executionDelay = 32;
                this.executionId = 2;
                this.entity.field_70180_af.func_187227_b(PERFORM_ATTACK_2_ANIM, (Object)true);
                this.entity.func_70661_as().func_75499_g();
            } else if (this.distanceToTarget > 5.0 && this.cdMove0 < 1 && this.entity.func_70090_H()) {
                this.cdMove0 = 100;
                BlockPos pos = this.entity.func_70638_az().func_233580_cy_();
                this.entity.func_223102_j(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                this.entity.func_70661_as().func_188554_j();
            } else {
                this.followTarget();
            }
        }

        private void performAttack() {
            ServerWorld serverWorld = this.entity.field_70170_p.func_73046_m().func_71218_a(this.entity.field_70170_p.func_234923_W_());
            switch (this.executionId) {
                case 0: {
                    if (this.distanceToTarget < 4.0) {
                        this.entity.field_70170_p.func_184133_a(null, this.entity.func_233580_cy_(), SoundEvents.field_187721_dT, SoundCategory.HOSTILE, 10.0f, 1.0f);
                        this.entity.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this.entity), 5.0f + (float)Math.round(this.entity.field_70146_Z.nextGaussian() * 10.0));
                    } else {
                        this.entity.field_70170_p.func_184133_a(null, this.entity.func_233580_cy_(), SoundEvents.field_187724_dU, SoundCategory.HOSTILE, 10.0f, 0.8f);
                    }
                    this.entity.field_70180_af.func_187227_b(PERFORM_ATTACK_0_ANIM, (Object)false);
                    this.cdAttack0 = 20;
                    break;
                }
                case 1: {
                    this.entity.field_70170_p.func_184133_a(null, this.entity.func_233580_cy_(), SoundEvents.field_232707_eX_, SoundCategory.HOSTILE, 10.0f, 0.8f);
                    AncientSkeletonEntity.this.spawnAttack1Particles(serverWorld);
                    AxisAlignedBB box = new AxisAlignedBB(this.entity.func_233580_cy_().func_177964_d(6).func_177965_g(6).func_177981_b(2), this.entity.func_233580_cy_().func_177970_e(6).func_177985_f(6).func_177979_c(2));
                    List entitiesInArea = this.entity.field_70170_p.func_72839_b((Entity)this.entity, box);
                    for (Entity areaEntity : entitiesInArea) {
                        areaEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.entity), 20.0f);
                    }
                    this.entity.field_70180_af.func_187227_b(PERFORM_ATTACK_1_ANIM, (Object)false);
                    this.cdAttack1 = 100;
                    break;
                }
                case 2: {
                    this.entity.func_181013_g(this.entity.field_70759_as);
                    SweepProjectileEntity sweepEntity = new SweepProjectileEntity((LivingEntity)this.entity, this.entity.field_70170_p);
                    sweepEntity.func_234612_a_((Entity)this.entity, this.entity.field_70125_A, this.entity.field_70759_as, 0.0f, 2.0f, 0.0f);
                    sweepEntity.func_189654_d(true);
                    sweepEntity.setDamage(4);
                    this.entity.field_70170_p.func_217376_c((Entity)sweepEntity);
                    this.entity.field_70170_p.func_184133_a(null, this.entity.func_233580_cy_(), SoundEvents.field_187631_bo, SoundCategory.HOSTILE, 8.0f, 3.0f);
                    this.entity.field_70180_af.func_187227_b(PERFORM_ATTACK_2_ANIM, (Object)false);
                    this.cdAttack2 = 70;
                }
            }
            this.executionId = -1;
        }
    }
}

