/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination.common.entities.CasterPiglin;

import com.github.x3rmination.core.registry.ItemInit;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinAction;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

@Mod.EventBusSubscriber(modid="x3dungeons")
public class CasterPiglinEntity
extends PiglinEntity
implements IAnimatable,
IRangedAttackMob {
    private AnimationFactory animationFactory = new AnimationFactory((IAnimatable)this);

    public CasterPiglinEntity(EntityType<? extends AbstractPiglinEntity> entityType, World world) {
        super(entityType, world);
    }

    protected boolean func_234422_eK_() {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 1.0);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 24.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal((IRangedAttackMob)this, (double)0.9f, 15, 24.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WitherSkeletonEntity.class, true));
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 4.0f, this::predicate));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (Math.abs(this.func_213322_ci().field_72450_a) > 0.01 || Math.abs(this.func_213322_ci().field_72449_c) > 0.01) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.caster_piglin.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.caster_piglin.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    @SubscribeEvent
    public static void tickEvent(LivingEquipmentChangeEvent event) {
        AbstractPiglinEntity piglinEntity;
        ItemStack stack;
        if (event.getEntity() instanceof AbstractPiglinEntity && (stack = (piglinEntity = (AbstractPiglinEntity)event.getEntity()).func_184582_a(EquipmentSlotType.HEAD)).func_77973_b().equals(ItemInit.EXPLORER_BANNER.get())) {
            piglinEntity.func_184212_Q().func_187227_b(AbstractPiglinEntity.field_242333_b, (Object)true);
        }
    }

    protected boolean func_242335_eK() {
        return true;
    }

    public PiglinAction func_234424_eM_() {
        return null;
    }

    protected void func_241848_eP() {
    }

    public void func_82227_f(boolean pChildZombie) {
    }

    protected void func_180481_a(DifficultyInstance pDifficulty) {
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }

    public void func_82196_d(LivingEntity target, float pVelocity) {
        float nextFloat = this.field_70146_Z.nextFloat();
        if (this.func_70032_d((Entity)target) < 4.0f) {
            if ((double)nextFloat < 0.5) {
                this.performFireBreathAttack();
                return;
            }
            this.performEvade();
        }
        if ((double)nextFloat < 0.7) {
            this.performFireAttack();
        } else {
            this.performGoldAttack();
        }
    }

    private void performEvade() {
        this.func_195064_c(new EffectInstance(Effects.field_188424_y, 20, 6));
        this.func_195064_c(new EffectInstance(Effects.field_204839_B, 600));
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 5, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private void performFireBreathAttack() {
        double radianYRot = (double)(MathHelper.func_76142_g((float)this.field_70759_as) + 90.0f) * Math.PI / 180.0;
        this.spawnFireRing(new Vector3d(this.func_213303_ch().field_72450_a + 2.0 * Math.cos(radianYRot), this.func_226278_cu_() + 1.0, this.func_213303_ch().field_72449_c + 2.0 * Math.sin(radianYRot)));
    }

    private void performFireAttack() {
        double radianYRot = (double)(MathHelper.func_76142_g((float)this.field_70759_as) + 90.0f) * Math.PI / 180.0;
        for (int i = 0; i < 50; ++i) {
            Vector3d pos = new Vector3d(this.func_213303_ch().field_72450_a + (0.5 + (double)((float)i / 5.0f)) * Math.cos(radianYRot), this.func_213303_ch().field_72448_b + 1.0 + (0.5 + (double)((float)i / 5.0f)) * Math.sin((double)MathHelper.func_76142_g((float)this.func_195050_f(0.0f)) * Math.PI / -180.0), this.func_213303_ch().field_72449_c + (0.5 + (double)((float)i / 5.0f)) * Math.sin(radianYRot));
            System.out.println(this.func_110148_a(Attributes.field_233821_d_).func_111126_e());
            List entities = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(pos.field_72450_a - 0.5, pos.field_72448_b - 0.5, pos.field_72449_c - 0.5, pos.field_72450_a + 0.5, pos.field_72448_b + 0.5, pos.field_72449_c + 0.5));
            entities.forEach(entity -> {
                if (!(entity instanceof AbstractPiglinEntity)) {
                    entity.func_70015_d(4);
                    entity.func_213317_d(this.func_70676_i(0.0f));
                }
            });
            this.spawnFireParticle(pos, 0.01);
        }
    }

    private void performGoldAttack() {
        List entities = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.func_226277_ct_() - 4.0, this.func_226278_cu_() - 4.0, this.func_226281_cx_() - 4.0, this.func_226277_ct_() + 4.0, this.func_226278_cu_() + 4.0, this.func_226281_cx_() + 4.0));
        for (Entity piglinEntity : entities) {
            if (!(piglinEntity instanceof AbstractPiglinEntity)) continue;
            ((AbstractPiglinEntity)piglinEntity).func_195064_c(new EffectInstance(Effects.field_76429_m));
        }
    }

    private void spawnFireRing(Vector3d origin) {
        List entities = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(origin.field_72450_a - 2.0, origin.field_72448_b - 2.0, origin.field_72449_c - 2.0, origin.field_72450_a + 2.0, origin.field_72448_b + 2.0, origin.field_72449_c + 2.0));
        entities.forEach(entity -> {
            if (!(entity instanceof AbstractPiglinEntity)) {
                entity.func_70015_d(10);
                entity.func_70097_a(DamageSource.field_76376_m, 1.0f);
            }
        });
        for (int i = 0; i < 50; ++i) {
            this.spawnFireParticle(origin, 0.1);
        }
    }

    private void spawnFireParticle(Vector3d pos, double speed) {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197631_x, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 1, 0.0, 0.0, 0.0, speed);
        }
    }
}

