/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination.common.entities.GiantPiglin;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinAction;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GiantPiglinEntity
extends AbstractPiglinEntity
implements IAnimatable {
    private AnimationFactory animationFactory = new AnimationFactory((IAnimatable)this);
    private static final DataParameter<Boolean> PERFORM_ATTACK_0_ANIM = EntityDataManager.func_187226_a(GiantPiglinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PERFORM_ATTACK_1_ANIM = EntityDataManager.func_187226_a(GiantPiglinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public GiantPiglinEntity(EntityType<? extends AbstractPiglinEntity> entityType, World world) {
        super(entityType, world);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 260.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 10.0);
    }

    public boolean func_230279_az_() {
        return true;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 24.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new GiantPiglinGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WitherSkeletonEntity.class, true));
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 4.0f, this::predicate));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (Boolean.TRUE.equals(this.field_70180_af.func_187225_a(PERFORM_ATTACK_0_ANIM))) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_piglin.swing0", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (Boolean.TRUE.equals(this.field_70180_af.func_187225_a(PERFORM_ATTACK_1_ANIM))) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_piglin.swing1", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_piglin.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_piglin.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_225511_J_()) {
            this.func_70106_y();
        } else {
            this.field_70708_bq = 0;
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld pLevel, DifficultyInstance pDifficulty, SpawnReason pReason, @Nullable ILivingEntityData pSpawnData, @Nullable CompoundNBT pDataTag) {
        pSpawnData = super.func_213386_a(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.func_180481_a(pDifficulty);
        this.func_180483_b(pDifficulty);
        return pSpawnData;
    }

    protected void func_180481_a(DifficultyInstance pDifficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151041_m));
    }

    protected boolean func_234422_eK_() {
        return false;
    }

    protected boolean func_242335_eK() {
        return true;
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (((Boolean)this.field_70180_af.func_187225_a(PERFORM_ATTACK_0_ANIM)).equals(Boolean.TRUE) || ((Boolean)this.field_70180_af.func_187225_a(PERFORM_ATTACK_1_ANIM)).equals(Boolean.TRUE)) {
            this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PERFORM_ATTACK_0_ANIM, (Object)false);
        this.field_70180_af.func_187214_a(PERFORM_ATTACK_1_ANIM, (Object)false);
    }

    public PiglinAction func_234424_eM_() {
        return null;
    }

    protected void func_241848_eP() {
    }

    @Nullable
    public LivingEntity func_70638_az() {
        return this.field_70696_bz;
    }

    public void func_70624_b(@Nullable LivingEntity pLivingEntity) {
        this.field_70696_bz = pLivingEntity;
    }

    public static class GiantPiglinGoal
    extends Goal {
        private final GiantPiglinEntity entity;
        private int pathDelay = 0;
        private int cdAttack0 = 0;
        private int cdAttack1 = 0;
        private int executionId = -1;
        private int executionDelay = 0;
        private int nextAttackDelay = 0;
        private double distanceToTarget;

        public GiantPiglinGoal(GiantPiglinEntity entity) {
            this.entity = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity target = this.entity.func_70638_az();
            return target != null && target.func_70089_S();
        }

        public void func_75249_e() {
            this.followTarget();
        }

        public void func_75251_c() {
            this.entity.func_70661_as().func_188554_j();
        }

        public void func_75246_d() {
            LivingEntity target = this.entity.func_70638_az();
            if (target == null || target.func_233643_dh_() || this.entity.field_70170_p == null) {
                return;
            }
            this.distanceToTarget = this.entity.func_70068_e((Entity)target);
            this.decreaseCoolDowns();
            this.entity.field_70749_g.func_75651_a((Entity)target, 30.0f, 30.0f);
            if (this.executionId == -1 && --this.nextAttackDelay < 1) {
                this.queueAttack();
            } else if (--this.executionDelay < 1) {
                this.performAttack();
            }
            if (--this.pathDelay < 1) {
                this.followTarget();
                this.pathDelay = 15;
            }
        }

        private void decreaseCoolDowns() {
            --this.cdAttack0;
            --this.cdAttack1;
        }

        private void followTarget() {
            if (this.entity.func_70638_az() != null && this.executionId == -1) {
                this.entity.func_70661_as().func_75497_a((Entity)this.entity.func_70638_az(), 1.0);
            }
        }

        private void queueAttack() {
            if (this.distanceToTarget < 4.0 && this.cdAttack0 < 1) {
                this.executionDelay = 20;
                this.executionId = 0;
                this.entity.field_70180_af.func_187227_b(PERFORM_ATTACK_0_ANIM, (Object)true);
                this.entity.func_70661_as().func_75499_g();
            } else if (this.distanceToTarget < 4.0 && this.cdAttack1 < 1) {
                this.executionDelay = 20;
                this.executionId = 1;
                this.entity.field_70180_af.func_187227_b(PERFORM_ATTACK_1_ANIM, (Object)true);
                this.entity.func_70661_as().func_75499_g();
            } else {
                this.followTarget();
            }
        }

        private void performAttack() {
            switch (this.executionId) {
                case 0: {
                    if (this.distanceToTarget < 4.0) {
                        this.entity.field_70170_p.func_184133_a(null, this.entity.func_233580_cy_(), SoundEvents.field_187736_dY, SoundCategory.HOSTILE, 10.0f, 1.0f);
                        this.entity.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this.entity), 7.0f + (float)Math.round(this.entity.field_70146_Z.nextGaussian() * 10.0));
                    } else {
                        this.entity.field_70170_p.func_184133_a(null, this.entity.func_233580_cy_(), SoundEvents.field_232708_eY_, SoundCategory.HOSTILE, 10.0f, 1.0f);
                    }
                    this.entity.field_70180_af.func_187227_b(PERFORM_ATTACK_0_ANIM, (Object)false);
                    this.cdAttack0 = 21;
                    break;
                }
                case 1: {
                    if (this.distanceToTarget < 4.0) {
                        this.entity.field_70170_p.func_184133_a(null, this.entity.func_233580_cy_(), SoundEvents.field_187736_dY, SoundCategory.HOSTILE, 10.0f, 1.0f);
                        this.entity.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this.entity), 7.0f + (float)Math.round(this.entity.field_70146_Z.nextGaussian() * 10.0));
                    } else {
                        this.entity.field_70170_p.func_184133_a(null, this.entity.func_233580_cy_(), SoundEvents.field_232708_eY_, SoundCategory.HOSTILE, 10.0f, 1.0f);
                    }
                    this.entity.field_70180_af.func_187227_b(PERFORM_ATTACK_1_ANIM, (Object)false);
                    this.cdAttack1 = 21;
                }
            }
            this.executionId = -1;
        }
    }
}

