/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination.common.entities.GiantPiglin;

import com.github.x3rmination.common.entities.GiantPiglin.GiantPiglinEntity;
import com.github.x3rmination.common.entities.GiantPiglin.GiantPiglinModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.ExtendedGeoEntityRenderer;

public class GiantPiglinRenderer
extends ExtendedGeoEntityRenderer<GiantPiglinEntity> {
    public GiantPiglinRenderer(EntityRendererManager renderManager) {
        this(renderManager, new GiantPiglinModel());
    }

    public GiantPiglinRenderer(EntityRendererManager renderManager, GiantPiglinModel modelProvider) {
        super(renderManager, (AnimatedGeoModel)modelProvider);
    }

    protected boolean isArmorBone(GeoBone bone) {
        return false;
    }

    @Nullable
    protected ResourceLocation getTextureForBone(String boneName, GiantPiglinEntity currentEntity) {
        return null;
    }

    @Nullable
    protected ItemStack getHeldItemForBone(String boneName, GiantPiglinEntity currentEntity) {
        switch (boneName) {
            case "bipedHandLeft": {
                return currentEntity.func_184638_cS() ? this.mainHand : this.offHand;
            }
            case "bipedHandRight": {
                return currentEntity.func_184638_cS() ? this.offHand : this.mainHand;
            }
        }
        return null;
    }

    @Nullable
    protected EquipmentSlotType getEquipmentSlotForArmorBone(String boneName, GiantPiglinEntity currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return EquipmentSlotType.FEET;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return EquipmentSlotType.LEGS;
            }
            case "armorBipedRightArm": {
                return !currentEntity.func_184638_cS() ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
            }
            case "armorBipedLeftArm": {
                return currentEntity.func_184638_cS() ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
            }
            case "armorBipedBody": {
                return EquipmentSlotType.CHEST;
            }
            case "armorBipedHead": {
                return EquipmentSlotType.HEAD;
            }
        }
        return null;
    }

    protected ItemCameraTransforms.TransformType getCameraTransformForItemAtBone(ItemStack boneItem, String boneName) {
        switch (boneName) {
            case "bipedHandLeft": 
            case "bipedHandRight": {
                return ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
        }
        return ItemCameraTransforms.TransformType.NONE;
    }

    @Nullable
    protected BlockState getHeldBlockForBone(String boneName, GiantPiglinEntity currentEntity) {
        return null;
    }

    protected void preRenderItem(MatrixStack matrixStack, ItemStack item, String boneName, GiantPiglinEntity currentEntity, IBone bone) {
        if (item == this.mainHand || item == this.offHand) {
            boolean shieldFlag;
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            matrixStack.func_227862_a_(2.0f, 2.0f, 2.0f);
            boolean bl = shieldFlag = item.isShield((LivingEntity)currentEntity) || item.func_77973_b() instanceof ShieldItem;
            if (item == this.mainHand) {
                if (shieldFlag) {
                    matrixStack.func_227861_a_(0.0, 0.125, -0.25);
                }
            } else if (shieldFlag) {
                matrixStack.func_227861_a_(0.0, 0.125, 0.0);
                matrixStack.func_227862_a_(-1.0f, 0.0f, 0.0f);
            }
        }
    }

    protected void preRenderBlock(MatrixStack matrixStack, BlockState block, String boneName, GiantPiglinEntity currentEntity) {
    }

    protected void postRenderItem(MatrixStack matrixStack, ItemStack item, String boneName, GiantPiglinEntity currentEntity, IBone bone) {
    }

    protected void postRenderBlock(MatrixStack matrixStack, BlockState block, String boneName, GiantPiglinEntity currentEntity) {
    }
}

