/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination.common.entities.GladiatorSkeleton;

import com.github.x3rmination.core.registry.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GladiatorSkeletonEntity
extends AbstractSkeletonEntity
implements IAnimatable {
    private AnimationFactory animationFactory = new AnimationFactory((IAnimatable)this);
    private static final DataParameter<Boolean> HAS_TARGET = EntityDataManager.func_187226_a(GladiatorSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public GladiatorSkeletonEntity(EntityType<? extends GladiatorSkeletonEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, WolfEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.9, false));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected SoundEvent func_190727_o() {
        return SoundEvents.field_187868_fj;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public void func_70636_d() {
        boolean flag = this.func_204609_dp();
        if (flag) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.HEAD);
            if (!itemstack.func_190926_b()) {
                if (itemstack.func_77984_f()) {
                    itemstack.func_196085_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                        this.func_213361_c(EquipmentSlotType.HEAD);
                        this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    protected void func_180481_a(DifficultyInstance pDifficulty) {
        if (pDifficulty.func_203095_a() == Difficulty.HARD && Math.random() > 0.7) {
            this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151161_ac));
            this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151163_ad));
            this.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)Items.field_151173_ae));
            this.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151175_af));
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ItemInit.DIAMOND_SPEAR.get()));
        } else {
            this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151028_Y));
            this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151030_Z));
            this.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)Items.field_151165_aa));
            this.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151167_ab));
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ItemInit.IRON_SPEAR.get()));
        }
        this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.field_185159_cQ));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld pLevel, DifficultyInstance pDifficulty, SpawnReason pReason, @Nullable ILivingEntityData pSpawnData, @Nullable CompoundNBT pDataTag) {
        pSpawnData = super.func_213386_a(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.func_180481_a(pDifficulty);
        this.func_180483_b(pDifficulty);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.45f * pDifficulty.func_180170_c());
        return pSpawnData;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 4.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.field_82175_bq) {
            if (Math.random() > 0.5) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_gladiator.attack0", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_gladiator.attack1", Boolean.valueOf(true)));
            }
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            if (this.hasTarget()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_gladiator.chase", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_gladiator.walk", Boolean.valueOf(true)));
            }
            return PlayState.CONTINUE;
        }
        if (this.hasTarget()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_gladiator.idle_chase", Boolean.valueOf(true)));
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_gladiator.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void func_70071_h_() {
        if (this.func_70638_az() != null) {
            this.field_70180_af.func_187227_b(HAS_TARGET, (Object)false);
        }
        super.func_70071_h_();
    }

    public void func_70624_b(@Nullable LivingEntity pLivingEntity) {
        if (pLivingEntity != null) {
            this.field_70180_af.func_187227_b(HAS_TARGET, (Object)true);
        }
        super.func_70624_b(pLivingEntity);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_TARGET, (Object)false);
    }

    public boolean hasTarget() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_TARGET);
    }
}

