/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination.common.entities.GladiatorSkeleton;

import com.github.x3rmination.common.entities.GladiatorSkeleton.GladiatorSkeletonEntity;
import com.github.x3rmination.common.entities.GladiatorSkeleton.GladiatorSkeletonModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.ExtendedGeoEntityRenderer;

public class GladiatorSkeletonRenderer
extends ExtendedGeoEntityRenderer<GladiatorSkeletonEntity> {
    public GladiatorSkeletonRenderer(EntityRendererManager rendererManager) {
        super(rendererManager, (AnimatedGeoModel)new GladiatorSkeletonModel());
    }

    public RenderType getRenderType(GladiatorSkeletonEntity animatable, float partialTicks, MatrixStack stack, @Nullable IRenderTypeBuffer renderTypeBuffer, @Nullable IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228640_c_((ResourceLocation)new ResourceLocation("x3dungeons", "textures/entity/gladiator_skeleton.png"));
    }

    @Nullable
    protected ItemStack getArmorForBone(String boneName, GladiatorSkeletonEntity currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return this.boots;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return this.leggings;
            }
            case "armorBipedBody": 
            case "armorBipedRightArm": 
            case "armorBipedLeftArm": {
                return this.chestplate;
            }
            case "armorBipedHead": {
                return this.helmet;
            }
        }
        return null;
    }

    @Nullable
    protected EquipmentSlotType getEquipmentSlotForArmorBone(String boneName, GladiatorSkeletonEntity currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return EquipmentSlotType.FEET;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return EquipmentSlotType.LEGS;
            }
            case "armorBipedRightArm": {
                return !currentEntity.func_184638_cS() ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
            }
            case "armorBipedLeftArm": {
                return currentEntity.func_184638_cS() ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
            }
            case "armorBipedBody": {
                return EquipmentSlotType.CHEST;
            }
            case "armorBipedHead": {
                return EquipmentSlotType.HEAD;
            }
        }
        return null;
    }

    @Nullable
    protected ModelRenderer getArmorPartForBone(String name, BipedModel<?> armorModel) {
        switch (name) {
            case "armorBipedLeftFoot": 
            case "armorBipedLeftLeg": {
                return armorModel.field_178722_k;
            }
            case "armorBipedRightFoot": 
            case "armorBipedRightLeg": {
                return armorModel.field_178721_j;
            }
            case "armorBipedRightArm": {
                return armorModel.field_178723_h;
            }
            case "armorBipedLeftArm": {
                return armorModel.field_178724_i;
            }
            case "armorBipedBody": {
                return armorModel.field_78115_e;
            }
            case "armorBipedHead": {
                return armorModel.field_78116_c;
            }
        }
        return null;
    }

    protected boolean isArmorBone(GeoBone bone) {
        return bone.getName().startsWith("armor");
    }

    @Nullable
    protected ResourceLocation getTextureForBone(String boneName, GladiatorSkeletonEntity currentEntity) {
        return null;
    }

    @Nullable
    protected ItemStack getHeldItemForBone(String boneName, GladiatorSkeletonEntity currentEntity) {
        switch (boneName) {
            case "bipedHandLeft": {
                return currentEntity.func_184638_cS() ? this.mainHand : this.offHand;
            }
            case "bipedHandRight": {
                return currentEntity.func_184638_cS() ? this.offHand : this.mainHand;
            }
        }
        return null;
    }

    protected ItemCameraTransforms.TransformType getCameraTransformForItemAtBone(ItemStack boneItem, String boneName) {
        switch (boneName) {
            case "bipedHandLeft": 
            case "bipedHandRight": {
                return ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
        }
        return ItemCameraTransforms.TransformType.NONE;
    }

    @Nullable
    protected BlockState getHeldBlockForBone(String boneName, GladiatorSkeletonEntity currentEntity) {
        return null;
    }

    protected void preRenderItem(MatrixStack matrixStack, ItemStack item, String boneName, GladiatorSkeletonEntity currentEntity, IBone bone) {
        if (item == this.mainHand || item == this.offHand) {
            boolean shieldFlag;
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            boolean bl = shieldFlag = item.isShield((LivingEntity)currentEntity) || item.func_77973_b() instanceof ShieldItem;
            if (item == this.mainHand) {
                if (shieldFlag) {
                    matrixStack.func_227861_a_(0.0, 0.125, -0.25);
                }
            } else if (shieldFlag) {
                matrixStack.func_227861_a_(0.0, 0.125, 0.0);
                matrixStack.func_227862_a_(-1.0f, 0.0f, 0.0f);
            }
        }
    }

    protected void preRenderBlock(MatrixStack matrixStack, BlockState block, String boneName, GladiatorSkeletonEntity currentEntity) {
    }

    protected void postRenderItem(MatrixStack matrixStack, ItemStack item, String boneName, GladiatorSkeletonEntity currentEntity, IBone bone) {
    }

    protected void postRenderBlock(MatrixStack matrixStack, BlockState block, String boneName, GladiatorSkeletonEntity currentEntity) {
    }
}

