/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination.common.entities.Spear;

import com.github.x3rmination.common.items.SpearItem;
import com.github.x3rmination.core.registry.EntityInit;
import com.github.x3rmination.core.registry.ItemInit;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class SpearEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    private ItemStack thrownStack = new ItemStack((IItemProvider)ItemInit.WOODEN_SPEAR.get());
    private ItemTier itemTier;
    private boolean dealtDamage;
    private static final DataParameter<Byte> LOYALTY_LEVEL = EntityDataManager.func_187226_a(SpearEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> IS_ENCHANTED = EntityDataManager.func_187226_a(SpearEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int returningTicks;

    public SpearEntity(EntityType<? extends SpearEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public SpearEntity(World worldIn, LivingEntity shooter, ItemStack thrownStackIn) {
        super((EntityType)EntityInit.SPEAR.get(), shooter, worldIn);
        this.thrownStack = thrownStackIn;
        this.itemTier = (ItemTier)((SpearItem)thrownStackIn.func_77973_b()).func_200891_e();
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)thrownStackIn)));
        this.field_70180_af.func_187227_b(IS_ENCHANTED, (Object)thrownStackIn.func_77962_s());
    }

    public ItemStack func_184550_j() {
        return this.thrownStack;
    }

    public ItemTier getItemTier() {
        if (this.itemTier == null) {
            return (ItemTier)((SpearItem)this.thrownStack.func_77973_b()).func_200891_e();
        }
        return this.itemTier;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LOYALTY_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(IS_ENCHANTED, (Object)false);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.getItemTier());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.itemTier = (ItemTier)additionalData.func_179257_a(ItemTier.class);
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.func_234616_v_();
        if ((this.dealtDamage || this.func_203047_q()) && entity != null) {
            byte i = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
            if (i > 0 && !this.shouldReturnToThrower()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (i > 0) {
                this.func_203045_n(true);
                Vector3d vector3d = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226280_cw_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vector3d.field_72448_b * 0.015 * (double)i, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double d0 = 0.05 * (double)i;
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.95).func_178787_e(vector3d.func_72432_b().func_186678_a(d0)));
                if (this.returningTicks == 0) {
                    this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.func_70071_h_();
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity entity1;
        Entity entity = result.func_216348_a();
        float f = this.getItemTier().func_200929_c() + 6.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.func_152377_a((ItemStack)this.thrownStack, (CreatureAttribute)livingentity.func_70668_bt());
        }
        DamageSource damagesource = DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)((entity1 = this.func_234616_v_()) == null ? this : entity1));
        this.dealtDamage = true;
        if (entity.func_70097_a(damagesource, f)) {
            if (entity.func_200600_R() == EntityType.field_200803_q) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.func_184548_a(livingentity1);
            }
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEnchanted() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_ENCHANTED);
    }
}

