/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination.common.items.Artifacts;

import com.github.x3rmination.common.items.Artifacts.ArtifactItem;
import com.github.x3rmination.common.items.Artifacts.attribute.CompactAttribute;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.capability.CurioItemCapability;

@Mod.EventBusSubscriber(modid="x3dungeons")
public class AngelWingItem
extends ArtifactItem {
    public AngelWingItem(Item.Properties properties, CompactAttribute ... compactAttribute) {
        super(properties, compactAttribute);
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return CurioItemCapability.createProvider((ICurio)new ICurio(){

            @Nonnull
            public ICurio.DropRule getDropRule(LivingEntity livingEntity) {
                return ICurio.DropRule.ALWAYS_DROP;
            }

            @Nonnull
            public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
                return new ICurio.SoundInfo(SoundEvents.field_187722_q, 1.0f, 1.0f);
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.getWearer();
                if (livingEntity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)livingEntity;
                    this.startFlying(player);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.getWearer();
                if (livingEntity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)livingEntity;
                    this.stopFlying(player);
                }
            }

            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                super.curioTick(identifier, index, livingEntity);
                if (livingEntity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)livingEntity;
                    if (!player.field_71075_bZ.field_75101_c) {
                        this.startFlying(player);
                    }
                }
            }

            private void startFlying(PlayerEntity player) {
                if (!player.func_184812_l_() && !player.func_175149_v()) {
                    player.field_71075_bZ.field_75101_c = true;
                    player.func_71016_p();
                }
            }

            private void stopFlying(PlayerEntity player) {
                if (!player.func_184812_l_() && !player.func_175149_v()) {
                    player.field_71075_bZ.field_75100_b = false;
                    player.field_71075_bZ.field_75101_c = false;
                    player.func_71016_p();
                }
            }

            public boolean canEquipFromUse(SlotContext slot) {
                return true;
            }
        });
    }
}

