/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination.common.items.Artifacts;

import com.github.x3rmination.common.items.Artifacts.attribute.CompactAttribute;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.capability.CurioItemCapability;

public class ArtifactItem
extends Item {
    private final Multimap<Attribute, AttributeModifier> attributeMap = LinkedHashMultimap.create();
    private ITextComponent defaultTooltip;

    public ArtifactItem(Item.Properties properties, CompactAttribute ... compactAttribute) {
        this(properties, (ITextComponent)null, compactAttribute);
    }

    public ArtifactItem(Item.Properties properties, @Nullable ITextComponent tooltip, CompactAttribute ... compactAttribute) {
        super(properties.func_200917_a(1));
        this.defaultTooltip = tooltip;
        if (compactAttribute != null) {
            List<CompactAttribute> compactAttributeList = Arrays.asList(compactAttribute);
            this.putAttributes(compactAttributeList);
        }
    }

    private void putAttributes(List<CompactAttribute> list) {
        for (CompactAttribute attribute : list) {
            this.attributeMap.put((Object)attribute.getAttribute(), (Object)new AttributeModifier(UUID.randomUUID(), attribute.getName(), (double)attribute.getModifier(), attribute.getOperation()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack pStack, @Nullable World pLevel, List<ITextComponent> pTooltip, ITooltipFlag pFlag) {
        super.func_77624_a(pStack, pLevel, pTooltip, pFlag);
        if (this.defaultTooltip != null) {
            pTooltip.add(this.defaultTooltip);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return CurioItemCapability.createProvider((ICurio)new ICurio(){

            public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid) {
                return ArtifactItem.this.attributeMap;
            }

            @Nonnull
            public ICurio.DropRule getDropRule(LivingEntity livingEntity) {
                return ICurio.DropRule.ALWAYS_DROP;
            }

            @Nonnull
            public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
                return new ICurio.SoundInfo(SoundEvents.field_187722_q, 1.0f, 1.0f);
            }

            public boolean canEquipFromUse(SlotContext slot) {
                return true;
            }
        });
    }
}

