/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination.common.items.Artifacts;

import com.github.x3rmination.core.registry.ItemInit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.capability.CurioItemCapability;

public class PendantOfHolinessItem
extends Item {
    public PendantOfHolinessItem(Item.Properties pProperties) {
        super(pProperties.func_200918_c(20));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack pStack, @Nullable World pLevel, List<ITextComponent> pTooltip, ITooltipFlag pFlag) {
        super.func_77624_a(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((ITextComponent)new TranslationTextComponent("tooltip.x3dungeons.pendant_of_holiness"));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return CurioItemCapability.createProvider((ICurio)new ICurio(){

            @Nonnull
            public ICurio.DropRule getDropRule(LivingEntity livingEntity) {
                return ICurio.DropRule.ALWAYS_DROP;
            }

            @Nonnull
            public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
                return new ICurio.SoundInfo(SoundEvents.field_187722_q, 1.0f, 1.0f);
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                super.onEquip(slotContext, prevStack);
                LivingEntity wearer = slotContext.getWearer();
                if (wearer instanceof PlayerEntity && !wearer.field_70170_p.field_72995_K) {
                    PlayerEntity player = (PlayerEntity)wearer;
                    Optional optionalPendant = CuriosApi.getCuriosHelper().findFirstCurio(wearer, (Item)ItemInit.PENDANT_OF_HOLINESS.get());
                    ArrayList wholeInventory = new ArrayList();
                    wholeInventory.addAll(player.field_71071_by.field_70462_a);
                    wholeInventory.addAll(player.field_71071_by.field_184439_c);
                    wholeInventory.addAll(player.field_71071_by.field_70460_b);
                    for (ItemStack stack : wholeInventory) {
                        Map<Enchantment, Integer> map = EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(p_217012_0_ -> !((Enchantment)p_217012_0_.getKey()).func_190936_d()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                        if (EnchantmentHelper.func_82781_a((ItemStack)stack).equals(map)) continue;
                        if (optionalPendant.isPresent()) {
                            ItemStack pendant = ((SlotResult)optionalPendant.orElse(null)).getStack();
                            pendant.func_222118_a(1, wearer, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
                        }
                        IFormattableTextComponent text = new TranslationTextComponent("x3dungeons.pendant_of_holiness.equip").func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)"0xc8b087"))).func_230529_a_(stack.func_151000_E());
                        wearer.func_145747_a((ITextComponent)text, Util.field_240973_b_);
                        wearer.field_70170_p.func_73046_m().func_71218_a(wearer.field_70170_p.func_234923_W_()).func_195598_a((IParticleData)ParticleTypes.field_197604_O, wearer.func_226277_ct_(), wearer.func_226278_cu_(), wearer.func_226281_cx_(), 10, 0.0, 1.0, 0.0, 0.5);
                        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_206933_aM, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        EnchantmentHelper.func_82782_a(map, (ItemStack)stack);
                    }
                }
            }

            public boolean canEquipFromUse(SlotContext slot) {
                return true;
            }
        });
    }
}

