/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination.common.items;

import com.github.x3rmination.common.entities.Spear.SpearEntity;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.enchantment.LoyaltyEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SpearItem
extends TieredItem
implements IVanishable {
    private final Multimap<Attribute, AttributeModifier> spearAttributes;
    private final int maxUseDuration;

    public SpearItem(IItemTier tier, Item.Properties properties) {
        super(tier, properties.func_200918_c(tier.func_200926_a()));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        float attackDamage = tier.func_200929_c() + 2.5f;
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)-2.9f, AttributeModifier.Operation.ADDITION));
        this.maxUseDuration = 10000;
        this.spearAttributes = builder.build();
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.SPEAR;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)entityLiving;
            int charge = this.func_77626_a(stack) - timeLeft;
            if (charge > 5 && !worldIn.field_72995_K) {
                stack.func_222118_a(1, (LivingEntity)playerentity, player -> player.func_213334_d(entityLiving.func_184600_cs()));
                SpearEntity spearEntity = new SpearEntity(worldIn, (LivingEntity)playerentity, stack);
                float maxUse = this.func_77626_a(stack);
                float currentTime = maxUse - (float)timeLeft;
                float ratio = Math.min(currentTime * 1000.0f / maxUse, 1.0f);
                spearEntity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, 1.5f * ratio, 1.0f);
                if (playerentity.field_71075_bZ.field_75098_d) {
                    spearEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
                worldIn.func_217376_c((Entity)spearEntity);
                if (!playerentity.field_71075_bZ.field_75098_d) {
                    playerentity.field_71071_by.func_184437_d(stack);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (itemstack.func_77952_i() >= itemstack.func_77958_k() - 1) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public int func_77626_a(ItemStack stack) {
        return this.maxUseDuration;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if ((double)state.func_185887_b((IBlockReader)worldIn, pos) != 0.0) {
            stack.func_222118_a(2, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public int func_77619_b() {
        return 1;
    }

    public IItemTier func_200891_e() {
        return super.func_200891_e();
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlotType.MAINHAND ? this.spearAttributes : super.func_111205_h(pEquipmentSlot);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.field_77351_y == EnchantmentType.WEAPON) {
            return true;
        }
        if (enchantment instanceof LoyaltyEnchantment) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

