/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination.common.structures;

import com.github.x3rmination.common.structures.StructureBase;
import com.github.x3rmination.core.registry.EntityInit;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SwagDragonStructure
extends StructureBase<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_MONSTERS = ImmutableList.of((Object)new MobSpawnInfo.Spawners((EntityType)EntityInit.GLADIATOR_SKELETON.get(), 1, 5, 10));

    public SwagDragonStructure() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return STRUCTURE_MONSTERS;
    }

    public boolean getDefaultRestrictsSpawnsToInside() {
        return true;
    }

    public static class FakeRandom
    extends Random {
        @Override
        public int nextInt(int bound) {
            return 0;
        }
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int x = chunkX * 16;
            int z = chunkZ * 16;
            BlockPos centerPos = new BlockPos(x, chunkGenerator.func_222532_b(x, z, Heightmap.Type.WORLD_SURFACE_WG) - 10, z);
            VillageConfig frontConfig = new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("x3dungeons", "swag_dragon/start_front_pool")), 10);
            VillageConfig middleConfig = new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("x3dungeons", "swag_dragon/start_middle_pool")), 10);
            VillageConfig backConfig = new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("x3dungeons", "swag_dragon/start_back_pool")), 10);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)frontConfig, AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)centerPos, (List)this.field_75075_a, (Random)new FakeRandom(), (boolean)false, (boolean)false);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)middleConfig, AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)centerPos, (List)this.field_75075_a, (Random)new FakeRandom(), (boolean)false, (boolean)false);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)backConfig, AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)centerPos, (List)this.field_75075_a, (Random)new FakeRandom(), (boolean)false, (boolean)false);
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, 1, 0));
            Vector3i structureCenter = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_215126_f();
            int xOffset = centerPos.func_177958_n() - structureCenter.func_177958_n();
            int zOffset = centerPos.func_177952_p() - structureCenter.func_177952_p();
            for (StructurePiece structurePiece : this.field_75075_a) {
                ResourceLocation resourceLocation = this.getResourceForPiece(structurePiece);
                switch (resourceLocation.func_110623_a()) {
                    case "swag_dragon_head": 
                    case "swag_dragon_neck": {
                        structurePiece.func_181138_a(9, 0, -19);
                        break;
                    }
                    case "swag_dragon_rib_back": 
                    case "swag_dragon_tail": {
                        structurePiece.func_181138_a(0, 0, 48);
                    }
                }
                structurePiece.func_181138_a(xOffset, 0, zOffset);
            }
            this.func_202500_a();
        }

        private ResourceLocation getResourceForPiece(StructurePiece structurePiece) {
            AbstractVillagePiece abstractVillagePiece;
            if (structurePiece instanceof AbstractVillagePiece && (abstractVillagePiece = (AbstractVillagePiece)structurePiece).func_214826_b() instanceof SingleJigsawPiece) {
                SingleJigsawPiece jigsawPiece = (SingleJigsawPiece)abstractVillagePiece.func_214826_b();
                Either template = jigsawPiece.field_236839_c_;
                if (template.left().isPresent()) {
                    return (ResourceLocation)template.left().orElseThrow(NullPointerException::new);
                }
            }
            return new ResourceLocation("x3dungeons", "empty");
        }
    }
}

