/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3rmination.core.registry;

import com.github.x3rmination.common.structures.PiglinCampStructure;
import com.github.x3rmination.common.structures.PiglinForgeStructure;
import com.github.x3rmination.common.structures.StructureBase;
import com.github.x3rmination.common.structures.SwagDragonStructure;
import com.github.x3rmination.common.structures.ZombieDungeonStructure;
import com.github.x3rmination.core.config.X3DUNGEONSConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class StructureInit {
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"x3dungeons");
    public static final RegistryObject<StructureBase<NoFeatureConfig>> SWAG_DRAGON = STRUCTURES.register("swag_dragon", SwagDragonStructure::new);
    public static final RegistryObject<StructureBase<NoFeatureConfig>> ZOMBIE_DUNGEON = STRUCTURES.register("zombie_dungeon", ZombieDungeonStructure::new);
    public static final RegistryObject<StructureBase<NoFeatureConfig>> PIGLIN_CAMP = STRUCTURES.register("piglin_camp", PiglinCampStructure::new);
    public static final RegistryObject<StructureBase<NoFeatureConfig>> PIGLIN_FORGE = STRUCTURES.register("piglin_forge", PiglinForgeStructure::new);

    public static void setupStructures() {
        StructureInit.setupMapSpacingAndLand((Structure)SWAG_DRAGON.get(), new StructureSeparationSettings(((Integer)X3DUNGEONSConfig.swag_dragon_max_seperation.get()).intValue(), ((Integer)X3DUNGEONSConfig.swag_dragon_min_seperation.get()).intValue(), 915238743), true);
        StructureInit.setupMapSpacingAndLand((Structure)ZOMBIE_DUNGEON.get(), new StructureSeparationSettings(50, 20, 1437860516), false);
        StructureInit.setupMapSpacingAndLand((Structure)PIGLIN_CAMP.get(), new StructureSeparationSettings(((Integer)X3DUNGEONSConfig.piglin_camp_max_seperation.get()).intValue(), ((Integer)X3DUNGEONSConfig.piglin_camp_min_seperation.get()).intValue(), 383452451), false);
        StructureInit.setupMapSpacingAndLand((Structure)PIGLIN_FORGE.get(), new StructureSeparationSettings(((Integer)X3DUNGEONSConfig.piglin_forge_max_seperation.get()).intValue(), ((Integer)X3DUNGEONSConfig.piglin_forge_min_seperation.get()).intValue(), 114452251), true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }
}

