/*
 * Decompiled with CFR 0.152.
 */
package com.mlib;

import com.mlib.Utility;
import com.mlib.config.DoubleConfig;
import com.mlib.math.VectorHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class Random {
    static final RandomSource CLIENT = RandomSource.m_216327_();
    static final RandomSource SERVER = RandomSource.m_216327_();

    public static RandomSource getThreadSafe() {
        return Utility.isServerSide() ? SERVER : CLIENT;
    }

    public static float nextFloat() {
        return Random.getThreadSafe().m_188501_();
    }

    public static float nextFloat(float min, float max) {
        return (max - min) * Random.nextFloat() + min;
    }

    public static double nextDouble() {
        return Random.getThreadSafe().m_188500_();
    }

    public static double nextDouble(double min, double max) {
        return (max - min) * Random.nextDouble() + min;
    }

    public static double nextGaussian() {
        return Random.getThreadSafe().m_188583_();
    }

    public static int nextInt() {
        return Random.getThreadSafe().m_188502_();
    }

    public static int nextInt(int max) {
        return Random.getThreadSafe().m_188503_(max);
    }

    public static int nextInt(int min, int max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            return max + Random.nextInt(min - max);
        }
        return min + Random.nextInt(max - min);
    }

    public static boolean nextBoolean() {
        return Random.getThreadSafe().m_188499_();
    }

    public static <Type> Type nextRandom(Type[] elements) {
        return elements.length > 0 ? (Type)elements[Random.nextInt(elements.length)] : null;
    }

    public static <Type> Type nextRandom(List<Type> elements) {
        return elements.size() > 0 ? (Type)elements.get(Random.nextInt(elements.size())) : null;
    }

    public static <Type> Type nextRandom(Set<Type> elements) {
        return (Type)Random.nextRandom(elements.toArray());
    }

    public static <Type1, Type2> Map.Entry<Type1, Type2> nextRandom(Map<Type1, Type2> elements) {
        return Random.nextRandom(elements.entrySet());
    }

    public static boolean tryChance(double chance) {
        return Random.nextDouble() <= chance;
    }

    public static boolean tryChance(DoubleConfig config) {
        return Random.tryChance((Double)config.get());
    }

    public static int roundRandomly(double experience) {
        int outputExperience;
        return outputExperience + (Random.tryChance(experience - (double)(outputExperience = (int)experience)) ? 1 : 0);
    }

    public static Vector3f getRandomVector3f(float minX, float maxX, float minY, float maxY, float minZ, float maxZ) {
        return new Vector3f(Random.nextFloat(minX, maxX), Random.nextFloat(minY, maxY), Random.nextFloat(minZ, maxZ));
    }

    public static Vec3 getRandomVector3d(double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        return new Vec3(Random.nextDouble(minX, maxX), Random.nextDouble(minY, maxY), Random.nextDouble(minZ, maxZ));
    }

    public static Vec3i getRandomVector3i(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        return new Vec3i(Random.nextInt(minX, maxX), Random.nextInt(minY, maxY), Random.nextInt(minZ, maxZ));
    }

    public static Vec3 getRandomNormalizedVector() {
        Vec3 vector = Random.getRandomVector3d(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        if (VectorHelper.length(vector) < 1.0E-5) {
            return Random.getRandomNormalizedVector();
        }
        return VectorHelper.normalize(vector);
    }
}

