/*
 * Decompiled with CFR 0.152.
 */
package com.mlib;

import com.mlib.MajruszLibrary;
import com.mlib.NetworkHandler;
import com.mlib.annotations.AnnotationHandler;
import com.mlib.commands.Command;
import com.mlib.features.AnyModification;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.registries.RegistryHelper;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class Registries {
    static final RegistryHelper HELPER = new RegistryHelper("mlib");
    static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = HELPER.create(ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS);
    static final List<Command> COMMANDS;
    static final List<GameModifier> GAME_MODIFIERS;

    public static void initialize() {
        HELPER.registerAll();
        MajruszLibrary.CONFIG_HANDLER.register(ModLoadingContext.get());
    }

    public static ResourceLocation getLocation(String register) {
        return HELPER.getLocation(register);
    }

    public static String getLocationString(String register) {
        return HELPER.getLocationString(register);
    }

    static {
        GameModifier.addNewGroup(MajruszLibrary.CONFIG_HANDLER, GameModifier.DEFAULT_KEY);
        LOOT_MODIFIERS.register("any_situation", AnyModification.CODEC);
        AnnotationHandler annotationHandler = new AnnotationHandler("mlib");
        COMMANDS = annotationHandler.getInstances(Command.class);
        GAME_MODIFIERS = annotationHandler.getInstances(GameModifier.class);
        MinecraftForge.EVENT_BUS.addListener(Command::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(NetworkHandler::register);
    }
}

