/*
 * Decompiled with CFR 0.152.
 */
package com.mlib;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.registries.ForgeRegistries;

public class Utility {
    public static final int TICKS_IN_SECOND = 20;
    public static final int TICKS_IN_MINUTE = 1200;

    public static int secondsToTicks(double seconds) {
        return (int)(seconds * 20.0);
    }

    public static double ticksToSeconds(int ticks) {
        return (double)ticks / 20.0;
    }

    public static int minutesToTicks(double minutes) {
        return (int)(minutes * 1200.0);
    }

    public static double ticksToMinutes(int ticks) {
        return (double)ticks / 1200.0;
    }

    @Nullable
    public static <NewType> NewType castIfPossible(Class<NewType> newClass, Object object) {
        return newClass.isInstance(object) ? (NewType)newClass.cast(object) : null;
    }

    public static ResourceLocation getRegistryKey(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static String getRegistryString(Item item) {
        return Utility.getRegistryKey(item).toString();
    }

    public static ResourceLocation getRegistryKey(ItemStack itemStack) {
        return Utility.getRegistryKey(itemStack.m_41720_());
    }

    public static String getRegistryString(ItemStack itemStack) {
        return Utility.getRegistryString(itemStack.m_41720_());
    }

    public static ResourceLocation getRegistryKey(EntityType<?> entityType) {
        return EntityType.m_20613_(entityType);
    }

    public static String getRegistryString(EntityType<?> entityType) {
        return Utility.getRegistryKey(entityType).toString();
    }

    public static ResourceLocation getRegistryKey(LivingEntity entity) {
        return Utility.getRegistryKey(entity.m_6095_());
    }

    public static String getRegistryString(LivingEntity entity) {
        return Utility.getRegistryString(entity.m_6095_());
    }

    public static ResourceLocation getRegistryKey(Enchantment enchantment) {
        return ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
    }

    public static String getRegistryString(Enchantment enchantment) {
        return Utility.getRegistryKey(enchantment).toString();
    }

    public static ResourceLocation getRegistryKey(Level level) {
        return level.m_46472_().m_135782_();
    }

    public static String getRegistryString(Level level) {
        return Utility.getRegistryKey(level).toString();
    }

    public static Item getItem(ResourceLocation location) {
        return (Item)ForgeRegistries.ITEMS.getValue(location);
    }

    public static Item getItem(String location) {
        return Utility.getItem(new ResourceLocation(location));
    }

    public static EntityType<?> getEntityType(ResourceLocation location) {
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location);
    }

    public static EntityType<?> getEntityType(String location) {
        return Utility.getEntityType(new ResourceLocation(location));
    }

    public static Enchantment getEnchantment(ResourceLocation location) {
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(location);
    }

    public static Enchantment getEnchantment(String location) {
        return Utility.getEnchantment(new ResourceLocation(location));
    }

    public static String getPlayerUUID(Player player) {
        return String.valueOf(player.m_20148_());
    }

    public static boolean isServerSide() {
        return Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER;
    }

    public static boolean isClientSide() {
        return Thread.currentThread().getThreadGroup() == SidedThreadGroups.CLIENT;
    }

    public static boolean isDevBuild() {
        return !FMLEnvironment.production;
    }
}

