/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.attributes;

import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeHandler {
    final UUID uuid;
    final String name;
    final Attribute attribute;
    final AttributeModifier.Operation operation;
    double value = 0.0;

    public AttributeHandler(String uuid, String name, Attribute attribute, AttributeModifier.Operation operation) {
        this.uuid = UUID.fromString(uuid);
        this.name = name;
        this.attribute = attribute;
        this.operation = operation;
    }

    public static boolean hasAttribute(LivingEntity entity, Attribute attribute) {
        return entity.m_21204_().m_22171_(attribute);
    }

    public boolean hasValueChanged(AttributeInstance attributeInstance) {
        AttributeModifier modifier = attributeInstance.m_22111_(this.uuid);
        return modifier == null || modifier.m_22218_() != this.value;
    }

    public double getValue() {
        return this.value;
    }

    public AttributeHandler setValue(double value) {
        this.value = value;
        return this;
    }

    public AttributeHandler apply(LivingEntity target) {
        AttributeInstance attributeInstance = target.m_21051_(this.attribute);
        if (attributeInstance != null && this.hasValueChanged(attributeInstance)) {
            attributeInstance.m_22120_(this.uuid);
            AttributeModifier modifier = this.createAttribute();
            attributeInstance.m_22125_(modifier);
        }
        return this;
    }

    public AttributeHandler setValueAndApply(LivingEntity target, double value) {
        this.setValue(value);
        return this.apply(target);
    }

    public AttributeModifier createAttribute() {
        return new AttributeModifier(this.uuid, this.name, this.value, this.operation);
    }

    public UUID getUUID() {
        return this.uuid;
    }
}

