/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mlib.data.ISerializable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

abstract class Data<Type>
implements ISerializable {
    final String key;
    final Supplier<Type> getter;
    final Consumer<Type> setter;

    protected Data(String key, Supplier<Type> getter, Consumer<Type> setter) {
        this.key = key;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public void read(JsonElement element) {
        if (this.key != null) {
            JsonObject object = element.getAsJsonObject();
            if (object.has(this.key)) {
                this.set(this.getJsonReader().read(object.get(this.key)));
            }
        } else {
            this.set(this.getJsonReader().read(element));
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.getBufferWriter().write(buffer, this.get());
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.set(this.getBufferReader().read(buffer));
    }

    @Override
    public void write(CompoundTag tag) {
        if (this.key == null || this.get() == null) {
            return;
        }
        this.getTagWriter().write(tag, this.key, this.get());
    }

    @Override
    public void read(CompoundTag tag) {
        if (this.key == null || !tag.m_128441_(this.key)) {
            return;
        }
        this.set(this.getTagReader().read(tag, this.key));
    }

    public void set(Type value) {
        this.setter.accept(value);
    }

    public Type get() {
        return this.getter.get();
    }

    protected abstract JsonReader<Type> getJsonReader();

    protected abstract BufferWriter<Type> getBufferWriter();

    protected abstract BufferReader<Type> getBufferReader();

    protected abstract TagWriter<Type> getTagWriter();

    protected abstract TagReader<Type> getTagReader();

    @FunctionalInterface
    protected static interface JsonReader<Type> {
        public Type read(JsonElement var1);
    }

    @FunctionalInterface
    protected static interface BufferWriter<Type> {
        public void write(FriendlyByteBuf var1, Type var2);
    }

    @FunctionalInterface
    protected static interface BufferReader<Type> {
        public Type read(FriendlyByteBuf var1);
    }

    @FunctionalInterface
    protected static interface TagWriter<Type> {
        public void write(CompoundTag var1, String var2, Type var3);
    }

    @FunctionalInterface
    protected static interface TagReader<Type> {
        public Type read(CompoundTag var1, String var2);
    }
}

