/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.effects;

import com.mlib.Random;
import com.mlib.math.VectorHelper;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class ParticleHandler {
    public static final ParticleHandler AWARD = new ParticleHandler(ParticleTypes.f_123748_, ParticleHandler.offset(0.25f), ParticleHandler.speed(0.1f));
    public static final ParticleHandler ENCHANTED_HIT = new ParticleHandler(ParticleTypes.f_123808_, ParticleHandler.offset(0.25f), ParticleHandler.speed(0.1f));
    public static final ParticleHandler ENCHANTED_GLYPH = new ParticleHandler(ParticleTypes.f_123809_, ParticleHandler.offset(0.25f), ParticleHandler.speed(0.1f));
    public static final ParticleHandler PORTAL = new ParticleHandler(ParticleTypes.f_123760_, ParticleHandler.offset(0.5f), () -> Float.valueOf(Random.nextFloat(-1.0f, 0.0f)));
    public static final ParticleHandler SMELT = new ParticleHandler(ParticleTypes.f_123744_, ParticleHandler.offset(0.1f), ParticleHandler.speed(0.01f));
    public static final ParticleHandler SMOKE = new ParticleHandler(ParticleTypes.f_123762_, ParticleHandler.offset(0.25f), ParticleHandler.speed(0.01f));
    public static final ParticleHandler SOUL = new ParticleHandler(ParticleTypes.f_123746_, ParticleHandler.offset(0.5f), ParticleHandler.speed(0.02f));
    public static final ParticleHandler WITCH = new ParticleHandler(ParticleTypes.f_123771_, ParticleHandler.offset(0.25f), ParticleHandler.speed(0.01f));
    final Supplier<SimpleParticleType> particleType;
    final Supplier<Vec3> offsetProvider;
    final Supplier<Float> speedProvider;

    public static Supplier<Vec3> offset(float value) {
        return () -> new Vec3((double)value, (double)value, (double)value);
    }

    public static Supplier<Float> speed(float value) {
        return () -> Float.valueOf(value);
    }

    public ParticleHandler(RegistryObject<? extends SimpleParticleType> particleType, Supplier<Vec3> offsetProvider, Supplier<Float> speedProvider) {
        this.particleType = () -> particleType.get();
        this.offsetProvider = offsetProvider;
        this.speedProvider = speedProvider;
    }

    public ParticleHandler(SimpleParticleType particleType, Supplier<Vec3> offsetProvider, Supplier<Float> speedProvider) {
        this.particleType = () -> particleType;
        this.offsetProvider = offsetProvider;
        this.speedProvider = speedProvider;
    }

    public void spawn(ServerLevel level, Vec3 position, int amountOfParticles, Supplier<Vec3> offsetProvider, Supplier<Float> speedProvider) {
        Vec3 offset = offsetProvider.get();
        level.m_8767_((ParticleOptions)this.particleType.get(), position.f_82479_, position.f_82480_, position.f_82481_, amountOfParticles, offset.f_82479_, offset.f_82480_, offset.f_82481_, (double)speedProvider.get().floatValue());
    }

    public void spawn(ServerLevel level, Vec3 position, int amountOfParticles, Supplier<Vec3> offsetProvider) {
        this.spawn(level, position, amountOfParticles, offsetProvider, this.speedProvider);
    }

    public void spawn(ServerLevel level, Vec3 position, int amountOfParticles) {
        this.spawn(level, position, amountOfParticles, this.offsetProvider, this.speedProvider);
    }

    public void spawnLine(ServerLevel level, Vec3 from, Vec3 to, int particlesPerBlock, Supplier<Vec3> offsetProvider, Supplier<Float> speedProvider) {
        Vec3 difference = VectorHelper.subtract(to, from);
        int amountOfParticles = (int)Math.ceil(from.m_82554_(to) * (double)particlesPerBlock);
        for (int i = 0; i <= amountOfParticles; ++i) {
            Vec3 step = VectorHelper.add(from, VectorHelper.multiply(difference, Float.valueOf((float)i / (float)amountOfParticles)));
            this.spawn(level, step, 1, offsetProvider, speedProvider);
        }
    }

    public void spawnLine(ServerLevel level, Vec3 from, Vec3 to, int particlesPerBlock, Supplier<Vec3> offsetProvider) {
        this.spawnLine(level, from, to, particlesPerBlock, offsetProvider, ParticleHandler.speed(0.0f));
    }

    public void spawnLine(ServerLevel level, Vec3 from, Vec3 to, int particlesPerBlock) {
        this.spawnLine(level, from, to, particlesPerBlock, ParticleHandler.offset(0.0f), ParticleHandler.speed(0.0f));
    }
}

