/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.effects;

import com.mlib.Random;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class SoundHandler {
    public static final Supplier<Float> DEFAULT_VOLUME = SoundHandler.randomized(0.7f);
    public static final Supplier<Float> DEFAULT_PITCH = SoundHandler.randomized(1.0f);
    public static final SoundHandler AWARD = new SoundHandler(SoundEvents.f_11871_, SoundSource.AMBIENT);
    public static final SoundHandler BONE_MEAL = new SoundHandler(SoundEvents.f_144074_, SoundSource.AMBIENT);
    public static final SoundHandler DRINK = new SoundHandler(SoundEvents.f_11911_, SoundSource.PLAYERS);
    public static final SoundHandler ENCHANT = new SoundHandler(SoundEvents.f_11887_, SoundSource.PLAYERS);
    public static final SoundHandler ENDERMAN_TELEPORT = new SoundHandler(SoundEvents.f_11852_, SoundSource.PLAYERS);
    public static final SoundHandler FIRE_EXTINGUISH = new SoundHandler(SoundEvents.f_11914_, SoundSource.AMBIENT);
    public static final SoundHandler HEARTBEAT = new SoundHandler(SoundEvents.f_215762_, SoundSource.PLAYERS);
    public static final SoundHandler ITEM_BREAK = new SoundHandler(SoundEvents.f_12018_, SoundSource.PLAYERS);
    public static final SoundHandler ITEM_PICKUP = new SoundHandler(SoundEvents.f_12019_, SoundSource.PLAYERS);
    public static final SoundHandler SMELT = new SoundHandler(SoundEvents.f_11874_, SoundSource.AMBIENT);
    final Supplier<SoundEvent> event;
    final SoundSource source;
    final Supplier<Float> volumeProvider;
    final Supplier<Float> pitchProvider;

    public static Supplier<Float> randomized(float value, float minRange, float maxRange) {
        return () -> Float.valueOf(value * Random.nextFloat(minRange, maxRange));
    }

    public static Supplier<Float> randomized(float value) {
        return SoundHandler.randomized(value, 0.8f, 1.2f);
    }

    public SoundHandler(RegistryObject<SoundEvent> event, SoundSource source, Supplier<Float> volumeProvider, Supplier<Float> pitchProvider) {
        this.event = event;
        this.source = source;
        this.volumeProvider = volumeProvider;
        this.pitchProvider = pitchProvider;
    }

    public SoundHandler(SoundEvent event, SoundSource source, Supplier<Float> volumeProvider, Supplier<Float> pitchProvider) {
        this.event = () -> event;
        this.source = source;
        this.volumeProvider = volumeProvider;
        this.pitchProvider = pitchProvider;
    }

    public SoundHandler(RegistryObject<SoundEvent> event, SoundSource source, Supplier<Float> volumeProvider) {
        this(event, source, volumeProvider, DEFAULT_PITCH);
    }

    public SoundHandler(SoundEvent event, SoundSource source, Supplier<Float> volumeProvider) {
        this(event, source, volumeProvider, DEFAULT_PITCH);
    }

    public SoundHandler(RegistryObject<SoundEvent> event, SoundSource source) {
        this(event, source, DEFAULT_VOLUME, DEFAULT_PITCH);
    }

    public SoundHandler(SoundEvent event, SoundSource source) {
        this(event, source, DEFAULT_VOLUME, DEFAULT_PITCH);
    }

    public void play(Level level, Vec3 position) {
        this.play(level, position, this.volumeProvider, this.pitchProvider);
    }

    public void play(Level level, Vec3 position, Supplier<Float> volumeProvider) {
        this.play(level, position, volumeProvider, this.pitchProvider);
    }

    public void play(Level level, Vec3 position, Supplier<Float> volumeProvider, Supplier<Float> pitchProvider) {
        level.m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, this.event.get(), this.source, volumeProvider.get().floatValue(), pitchProvider.get().floatValue());
    }

    public void send(ServerPlayer player, Vec3 position, Supplier<Float> volumeProvider, Supplier<Float> pitchProvider) {
        Holder holder = ForgeRegistries.SOUND_EVENTS.getHolder((Object)this.event.get()).orElse(null);
        if (holder == null) {
            return;
        }
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(holder, this.source, position.f_82479_, position.f_82480_, position.f_82481_, volumeProvider.get().floatValue(), pitchProvider.get().floatValue(), (long)Random.nextInt()));
    }

    public void send(ServerPlayer player, Vec3 position, Supplier<Float> volumeProvider) {
        this.send(player, position, volumeProvider, this.pitchProvider);
    }

    public void send(ServerPlayer player, Vec3 position) {
        this.send(player, position, this.volumeProvider, this.pitchProvider);
    }
}

