/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.features;

import com.mlib.Random;
import com.mlib.annotations.AutoInstance;
import com.mlib.entities.EntityHelper;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnExtraFishingLootCheck;
import com.mlib.gamemodifiers.contexts.OnItemFished;
import com.mlib.gamemodifiers.parameters.Priority;
import com.mlib.math.VectorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.ItemFishedEvent;

@AutoInstance
public class FishingLootIncreaser
extends GameModifier {
    public FishingLootIncreaser() {
        new OnItemFished.Context(this::increaseLoot).priority(Priority.HIGHEST).addCondition(new Condition.IsServer()).insertTo(this);
    }

    private void increaseLoot(OnItemFished.Data data) {
        OnExtraFishingLootCheck.Data extraData = this.dispatchContext(data);
        if (extraData.isExtraLootEmpty()) {
            return;
        }
        this.spawnLoot(data, extraData.extraLoot);
        this.spawnExperience(data, extraData.extraExperience);
        this.damageFishingRod(data, extraData.extraRodDamage);
        this.sendMessage(data, extraData.extraLoot);
    }

    private OnExtraFishingLootCheck.Data dispatchContext(OnItemFished.Data data) {
        return OnExtraFishingLootCheck.Context.accept(new OnExtraFishingLootCheck.Data(data));
    }

    private void spawnLoot(OnItemFished.Data data, List<ItemStack> extraLoot) {
        extraLoot.forEach(itemStack -> {
            Vec3 offset = Random.getRandomVector3d(-0.25, 0.25, 0.125, 0.5, -0.25, 0.25);
            Vec3 spawnPosition = data.hook.m_20182_().m_82549_(offset);
            ItemEntity itemEntity = new ItemEntity((Level)data.level, spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_, itemStack);
            Vec3 motion = data.player.m_20182_().m_82546_(itemEntity.m_20182_()).m_82542_(0.1, 0.1, 0.1);
            itemEntity.m_20256_(motion.m_82520_(0.0, Math.pow(VectorHelper.length(motion), 0.5) * 0.25, 0.0));
            data.level.m_7967_((Entity)itemEntity);
        });
    }

    private void spawnExperience(OnItemFished.Data data, int experience) {
        if (experience > 0) {
            EntityHelper.spawnExperience((Level)data.level, VectorHelper.add(data.player.m_20182_(), 0.5), experience);
        }
    }

    private void damageFishingRod(OnItemFished.Data data, int damage) {
        ((ItemFishedEvent)data.event).damageRodBy(((ItemFishedEvent)data.event).getRodDamage() + damage);
    }

    private void sendMessage(OnItemFished.Data data, List<ItemStack> extraLoot) {
        List<FishedItem> fishedItems = this.buildFishedItemList(data, extraLoot);
        MutableComponent message = this.buildMessage(fishedItems);
        data.player.m_5661_((Component)message, true);
    }

    private List<FishedItem> buildFishedItemList(OnItemFished.Data data, List<ItemStack> extraLoot) {
        ArrayList<FishedItem> fishedItems = new ArrayList<FishedItem>();
        BiConsumer<ItemStack, Boolean> addItem = (itemStack, isExtra) -> {
            for (FishedItem fishedItem : fishedItems) {
                if (!fishedItem.is((ItemStack)itemStack)) continue;
                fishedItem.increase((ItemStack)itemStack, (boolean)isExtra);
                return;
            }
            fishedItems.add(new FishedItem((ItemStack)itemStack, (boolean)isExtra));
        };
        data.drops.forEach(itemStack -> addItem.accept((ItemStack)itemStack, false));
        extraLoot.forEach(itemStack -> addItem.accept((ItemStack)itemStack, true));
        return fishedItems;
    }

    private MutableComponent buildMessage(List<FishedItem> fishedItems) {
        MutableComponent message = Component.m_237113_((String)"(").m_130940_(ChatFormatting.WHITE);
        for (int idx = 0; idx < fishedItems.size(); ++idx) {
            if (idx > 0) {
                message.m_130946_(", ");
            }
            message.m_7220_((Component)fishedItems.get(idx).build());
        }
        return message.m_7220_((Component)Component.m_237113_((String)")"));
    }

    private static class FishedItem {
        public final ItemStack itemStack;
        public final ChatFormatting itemFormatting;
        public int count;
        public ChatFormatting countFormatting;

        public FishedItem(ItemStack itemStack, boolean isExtra) {
            ChatFormatting formatting = isExtra ? ChatFormatting.GOLD : ChatFormatting.WHITE;
            this.itemStack = itemStack;
            this.itemFormatting = formatting;
            this.count = itemStack.m_41613_();
            this.countFormatting = formatting;
        }

        public MutableComponent build() {
            return this.itemStack.m_41720_().m_7626_(this.itemStack).m_6881_().m_130940_(this.itemFormatting).m_7220_((Component)Component.m_237113_((String)(this.count > 1 ? String.format(" x%d", this.count) : "")).m_130940_(this.countFormatting));
        }

        public void increase(ItemStack itemStack, boolean isExtra) {
            this.count += itemStack.m_41613_();
            if (isExtra) {
                this.countFormatting = ChatFormatting.GOLD;
            }
        }

        public boolean is(ItemStack itemStack) {
            return this.itemStack.m_41720_().equals(itemStack.m_41720_());
        }
    }
}

