/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers;

import com.mlib.MajruszLibrary;
import com.mlib.Registries;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.ContextBase;
import com.mlib.gamemodifiers.ContextData;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public abstract class GameModifier
extends ConfigGroup {
    public static final String DEFAULT_KEY = Registries.getLocationString("default");
    final List<ContextBase<? extends ContextData>> contexts = new ArrayList<ContextBase<? extends ContextData>>();
    final String configKey;

    public static ConfigGroup addNewGroup(String key) {
        ConfigGroup group = new ConfigGroup(new IConfigurable[0]);
        MajruszLibrary.MOD_CONFIGS.setup(key, group);
        return group;
    }

    public static ConfigGroup addNewGroup(ConfigGroup parent, String key) {
        ConfigGroup group = GameModifier.addNewGroup(key);
        parent.addGroup(group);
        return group;
    }

    public static ConfigGroup addNewGroup(String parentKey, String key) {
        return GameModifier.addNewGroup(MajruszLibrary.MOD_CONFIGS.get(parentKey), key);
    }

    public GameModifier(String configKey) {
        super(new IConfigurable[0]);
        this.configKey = configKey;
        MajruszLibrary.MOD_CONFIGS.insert(configKey, this);
    }

    public GameModifier() {
        this(DEFAULT_KEY);
    }

    public <DataType extends ContextData> void addContext(ContextBase<DataType> context) {
        context.setup(this);
        this.addConfig(context);
    }

    public void addContexts(ContextBase<?> ... contexts) {
        Stream.of(contexts).forEach(this::addContext);
    }

    public List<ContextBase<? extends ContextData>> getContexts() {
        return this.contexts;
    }

    public String getConfigKey() {
        return this.configKey;
    }
}

