/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers.contexts;

import com.mlib.Utility;
import com.mlib.gamemodifiers.ContextBase;
import com.mlib.gamemodifiers.ContextData;
import com.mlib.gamemodifiers.Contexts;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;

public class OnExplosion {

    public static class Data
    extends ContextData.Event<ExplosionEvent> {
        public final Explosion explosion;
        @Nullable
        public final LivingEntity sourceMob;
        public final MutableFloat radius;
        public final MutableBoolean causesFire;

        public Data(ExplosionEvent event) {
            super(Utility.castIfPossible(ServerLevel.class, event.getLevel()), event);
            this.explosion = event.getExplosion();
            this.sourceMob = this.explosion.m_252906_();
            this.radius = new MutableFloat(this.explosion.f_46017_);
            this.causesFire = new MutableBoolean(this.explosion.f_46009_);
        }
    }

    @Mod.EventBusSubscriber
    public static class Context
    extends ContextBase<Data> {
        static final Contexts<Data, Context> CONTEXTS = new Contexts();

        public Context(Consumer<Data> consumer) {
            super(consumer);
            CONTEXTS.add(this);
        }

        @SubscribeEvent
        public static void onExplosionStart(ExplosionEvent.Start event) {
            Data data = new Data((ExplosionEvent)event);
            CONTEXTS.accept(data);
            Context.updateEvent(data);
        }

        @SubscribeEvent
        public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
            CONTEXTS.accept(new Data((ExplosionEvent)event));
        }

        private static void updateEvent(Data data) {
            if ((double)(data.radius.getValue().floatValue() - data.explosion.f_46017_) < 1.0 || data.level == null) {
                return;
            }
            data.explosion.f_46017_ = data.radius.getValue().floatValue();
            data.explosion.f_46009_ = data.causesFire.getValue();
            double x = data.explosion.getPosition().f_82479_;
            double y = data.explosion.getPosition().f_82480_;
            double z = data.explosion.getPosition().f_82481_;
            for (ServerPlayer player : data.level.m_6907_()) {
                if (!(player.m_20275_(x, y, z) < 4096.0)) continue;
                player.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, data.explosion.f_46017_, data.explosion.m_46081_(), (Vec3)data.explosion.m_46078_().get(player)));
            }
        }
    }
}

