/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers.contexts;

import com.mlib.Random;
import com.mlib.gamemodifiers.ContextBase;
import com.mlib.gamemodifiers.ContextData;
import com.mlib.gamemodifiers.Contexts;
import com.mlib.gamemodifiers.contexts.OnItemFished;
import com.mlib.items.ItemHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.ToolActions;

public class OnExtraFishingLootCheck {

    public static class Data
    extends ContextData {
        public final List<ItemStack> drops;
        public final List<ItemStack> extraLoot = new ArrayList<ItemStack>();
        public final Player player;
        public final ItemStack fishingRod;
        public int extraExperience = 0;
        public int extraRodDamage = 0;

        public Data(OnItemFished.Data data) {
            super((Entity)data.player);
            this.drops = Collections.unmodifiableList(data.drops);
            this.player = data.player;
            this.fishingRod = ItemHelper.getMatchingHandItem((LivingEntity)this.player, Data::isFishingRod);
        }

        public LootContext generateLootContext() {
            return new LootContext.Builder((ServerLevel)this.player.f_19853_).m_78972_(LootContextParams.f_81463_, (Object)this.fishingRod).m_230911_(Random.getThreadSafe()).m_78963_(this.player.m_36336_()).m_78972_(LootContextParams.f_81460_, (Object)this.player.m_20182_()).m_78975_(LootContextParamSets.f_81414_);
        }

        public boolean isExtraLootEmpty() {
            return this.extraLoot.isEmpty();
        }

        private static boolean isFishingRod(ItemStack itemStack) {
            return itemStack.m_41720_().canPerformAction(itemStack, ToolActions.FISHING_ROD_CAST);
        }
    }

    public static class Context
    extends ContextBase<Data> {
        static final Contexts<Data, Context> CONTEXTS = new Contexts();

        public static Data accept(Data data) {
            return CONTEXTS.accept(data);
        }

        public Context(Consumer<Data> consumer) {
            super(consumer);
            CONTEXTS.add(this);
        }
    }
}

