/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers.contexts;

import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ContextBase;
import com.mlib.gamemodifiers.ContextData;
import com.mlib.gamemodifiers.Contexts;
import com.mlib.gamemodifiers.GameModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class OnSpawned {
    @Deprecated(since="3.2.0 (use IsNotLoadedFromDisk class instead)", forRemoval=true)
    public static final Predicate<Data> IS_NOT_LOADED_FROM_DISK = data -> !data.loadedFromDisk;

    public static class Data
    extends ContextData {
        public final LivingEntity target;
        public final boolean loadedFromDisk;

        public Data(LivingEntity target, boolean loadedFromDisk) {
            super((Entity)target);
            this.target = target;
            this.loadedFromDisk = loadedFromDisk;
        }
    }

    public static class Is<Type extends Data>
    extends Condition<Type> {
        final Class<?>[] classes;

        public Is(Class<?> ... classes) {
            this.classes = classes;
        }

        @Override
        protected boolean check(GameModifier feature, Type data) {
            return Arrays.stream(this.classes).anyMatch(clazz -> data.target.getClass().equals(clazz));
        }
    }

    public static class IsNotLoadedFromDisk<Type extends Data>
    extends Condition<Type> {
        @Override
        protected boolean check(GameModifier feature, Type data) {
            return !((Data)data).loadedFromDisk;
        }
    }

    @Mod.EventBusSubscriber
    public static class ContextSafe
    extends ContextBase<Data> {
        static final Contexts<Data, ContextSafe> CONTEXTS = new Contexts();
        static final List<Data> CLIENT_PENDING_LIST = new ArrayList<Data>();
        static final List<Data> SERVER_PENDING_LIST = new ArrayList<Data>();

        public ContextSafe(Consumer<Data> consumer) {
            super(consumer);
            CONTEXTS.add(this);
        }

        @SubscribeEvent
        public static void onSpawn(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity2 = (LivingEntity)entity;
            List<Data> list = entity2.f_19853_.f_46443_ ? CLIENT_PENDING_LIST : SERVER_PENDING_LIST;
            list.add(new Data(entity2, event.loadedFromDisk()));
        }

        @SubscribeEvent
        public static void onClientTickEnd(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            ContextSafe.handle(CLIENT_PENDING_LIST);
        }

        @SubscribeEvent
        public static void onServerTickEnd(TickEvent.ServerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            ContextSafe.handle(SERVER_PENDING_LIST);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void handle(List<Data> pendingList) {
            ArrayList<Data> list;
            List<Data> list2 = pendingList;
            synchronized (list2) {
                list = new ArrayList<Data>(pendingList);
                pendingList.clear();
            }
            list.forEach(data -> {
                if (data.target.isAddedToWorld()) {
                    CONTEXTS.accept((Data)data);
                }
            });
        }
    }

    @Mod.EventBusSubscriber
    public static class Context
    extends ContextBase<Data> {
        static final Contexts<Data, Context> CONTEXTS = new Contexts();

        public Context(Consumer<Data> consumer) {
            super(consumer);
            CONTEXTS.add(this);
        }

        @SubscribeEvent
        public static void onSpawn(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity2 = (LivingEntity)entity;
            CONTEXTS.accept(new Data(entity2, event.loadedFromDisk()));
        }
    }
}

