/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.math;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VectorHelper {
    public static Vector3f add(Vector3f vector1, Vector3f vector2) {
        return new Vector3f(vector1.x() + vector2.x(), vector1.y() + vector2.y(), vector1.z() + vector2.z());
    }

    public static Vector3d add(Vector3d vector1, Vector3d vector2) {
        return new Vector3d(vector1.x + vector2.x, vector1.y + vector2.y, vector1.z + vector2.z);
    }

    public static Vec3 add(Vec3 vector1, Vec3 vector2) {
        return new Vec3(vector1.f_82479_ + vector2.f_82479_, vector1.f_82480_ + vector2.f_82480_, vector1.f_82481_ + vector2.f_82481_);
    }

    public static <Type extends Number> Vec3 add(Vec3 vector, Type value) {
        return new Vec3(vector.f_82479_ + value.doubleValue(), vector.f_82480_ + value.doubleValue(), vector.f_82481_ + value.doubleValue());
    }

    public static Vector3f negate(Vector3f vector) {
        return new Vector3f(-vector.x(), -vector.y(), -vector.z());
    }

    public static Vector3d negate(Vector3d vector) {
        return new Vector3d(-vector.x, -vector.y, -vector.z);
    }

    public static Vec3 negate(Vec3 vector) {
        return new Vec3(-vector.f_82479_, -vector.f_82480_, -vector.f_82481_);
    }

    public static Vector3f subtract(Vector3f vector1, Vector3f vector2) {
        return VectorHelper.add(vector1, VectorHelper.negate(vector2));
    }

    public static Vector3d subtract(Vector3d vector1, Vector3d vector2) {
        return VectorHelper.add(vector1, VectorHelper.negate(vector2));
    }

    public static Vec3 subtract(Vec3 vector1, Vec3 vector2) {
        return VectorHelper.add(vector1, VectorHelper.negate(vector2));
    }

    public static <Type extends Number> Vec3 subtract(Vec3 vector, Type value) {
        return VectorHelper.add(vector, -value.doubleValue());
    }

    public static Vector3f multiply(Vector3f vector1, Vector3f vector2) {
        return new Vector3f(vector1.x() * vector2.x(), vector1.y() * vector2.y(), vector1.z() * vector2.z());
    }

    public static Vector3d multiply(Vector3d vector1, Vector3d vector2) {
        return new Vector3d(vector1.x * vector2.x, vector1.y * vector2.y, vector1.z * vector2.z);
    }

    public static Vec3 multiply(Vec3 vector1, Vec3 vector2) {
        return new Vec3(vector1.f_82479_ * vector2.f_82479_, vector1.f_82480_ * vector2.f_82480_, vector1.f_82481_ * vector2.f_82481_);
    }

    public static <Type extends Number> Vec3 multiply(Vec3 vector, Type value) {
        return new Vec3(vector.f_82479_ * value.doubleValue(), vector.f_82480_ * value.doubleValue(), vector.f_82481_ * value.doubleValue());
    }

    public static Vector3f divide(Vector3f vector1, Vector3f vector2) {
        return new Vector3f(vector1.x() / vector2.x(), vector1.y() / vector2.y(), vector1.z() / vector2.z());
    }

    public static Vector3d divide(Vector3d vector1, Vector3d vector2) {
        return new Vector3d(vector1.x / vector2.x, vector1.y / vector2.y, vector1.z / vector2.z);
    }

    public static Vec3 divide(Vec3 vector1, Vec3 vector2) {
        return new Vec3(vector1.f_82479_ / vector2.f_82479_, vector1.f_82480_ / vector2.f_82480_, vector1.f_82481_ / vector2.f_82481_);
    }

    public static <Type extends Number> Vec3 divide(Vec3 vector, Type value) {
        return new Vec3(vector.f_82479_ / value.doubleValue(), vector.f_82480_ / value.doubleValue(), vector.f_82481_ / value.doubleValue());
    }

    public static float dot(Vector3f vector1, Vector3f vector2) {
        return vector1.dot((Vector3fc)vector2);
    }

    public static float dot(Vector3f vector) {
        return VectorHelper.dot(vector, vector);
    }

    public static double dot(Vector3d vector1, Vector3d vector2) {
        return vector1.x * vector2.x + vector1.y * vector2.y + vector1.z * vector2.z;
    }

    public static double dot(Vector3d vector) {
        return VectorHelper.dot(vector, vector);
    }

    public static double dot(Vec3 vector1, Vec3 vector2) {
        return vector1.m_82526_(vector2);
    }

    public static double dot(Vec3 vector) {
        return VectorHelper.dot(vector, vector);
    }

    public static float distanceSquared(Vector3f vector1, Vector3f vector2) {
        return VectorHelper.dot(VectorHelper.subtract(vector1, vector2));
    }

    public static float distance(Vector3f vector1, Vector3f vector2) {
        return (float)Math.sqrt(VectorHelper.distanceSquared(vector1, vector2));
    }

    public static float distanceHorizontal(Vector3f vector1, Vector3f vector2) {
        return VectorHelper.distance(new Vector3f(vector1.x, 0.0f, vector1.z), new Vector3f(vector2.x, 0.0f, vector2.z));
    }

    public static float length(Vector3f vector) {
        return VectorHelper.distance(vector, new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public static double distanceSquared(Vector3d vector1, Vector3d vector2) {
        return VectorHelper.dot(VectorHelper.subtract(vector1, vector2));
    }

    public static double distance(Vector3d vector1, Vector3d vector2) {
        return Math.sqrt(VectorHelper.distanceSquared(vector1, vector2));
    }

    public static double distanceHorizontal(Vector3d vector1, Vector3d vector2) {
        return VectorHelper.distance(new Vector3d(vector1.x, 0.0, vector1.z), new Vector3d(vector2.x, 0.0, vector2.z));
    }

    public static double length(Vector3d vector) {
        return VectorHelper.distance(vector, new Vector3d(0.0, 0.0, 0.0));
    }

    public static double distanceSquared(Vec3 vector1, Vec3 vector2) {
        return VectorHelper.dot(VectorHelper.subtract(vector1, vector2));
    }

    public static double distance(Vec3 vector1, Vec3 vector2) {
        return Math.sqrt(VectorHelper.distanceSquared(vector1, vector2));
    }

    public static double distanceHorizontal(Vec3 vector1, Vec3 vector2) {
        return VectorHelper.distance(new Vec3(vector1.f_82479_, 0.0, vector1.f_82481_), new Vec3(vector2.f_82479_, 0.0, vector2.f_82481_));
    }

    public static double length(Vec3 vector) {
        return VectorHelper.distance(vector, new Vec3(0.0, 0.0, 0.0));
    }

    public static Vector3f normalize(Vector3f vector) {
        float length = VectorHelper.length(vector);
        return (double)length < 1.0E-4 ? vector : VectorHelper.divide(vector, new Vector3f(length, length, length));
    }

    public static Vector3d normalize(Vector3d vector) {
        double length = VectorHelper.length(vector);
        return length < 1.0E-4 ? vector : VectorHelper.divide(vector, new Vector3d(length, length, length));
    }

    public static Vec3 normalize(Vec3 vector) {
        double length = VectorHelper.length(vector);
        return length < 1.0E-4 ? vector : VectorHelper.divide(vector, new Vec3(length, length, length));
    }

    public static Vector3f lerp(float ratio, Vector3f vector1, Vector3f vector2) {
        float x = Mth.m_14179_((float)ratio, (float)vector1.x(), (float)vector2.x());
        float y = Mth.m_14179_((float)ratio, (float)vector1.y(), (float)vector2.y());
        float z = Mth.m_14179_((float)ratio, (float)vector1.z(), (float)vector2.z());
        return new Vector3f(x, y, z);
    }

    public static Vector3d lerp(double ratio, Vector3d vector1, Vector3d vector2) {
        double x = Mth.m_14139_((double)ratio, (double)vector1.x, (double)vector2.x);
        double y = Mth.m_14139_((double)ratio, (double)vector1.y, (double)vector2.y);
        double z = Mth.m_14139_((double)ratio, (double)vector1.z, (double)vector2.z);
        return new Vector3d(x, y, z);
    }

    public static Vec3 lerp(double ratio, Vec3 vector1, Vec3 vector2) {
        double x = Mth.m_14139_((double)ratio, (double)vector1.f_82479_, (double)vector2.f_82479_);
        double y = Mth.m_14139_((double)ratio, (double)vector1.f_82480_, (double)vector2.f_82480_);
        double z = Mth.m_14139_((double)ratio, (double)vector1.f_82481_, (double)vector2.f_82481_);
        return new Vec3(x, y, z);
    }

    public static BlockPos block(Vec3 vector) {
        return new BlockPos(vector.f_82479_, vector.f_82480_, vector.f_82481_);
    }

    public static BlockPos block(Vector3f vector) {
        return new BlockPos((double)vector.x(), (double)vector.y(), (double)vector.z());
    }

    public static BlockPos block(Vector3d vector) {
        return new BlockPos(vector.x, vector.y, vector.z);
    }

    public static Vec3 vec3(BlockPos blockPosition) {
        return new Vec3((double)blockPosition.m_123341_() + 0.5, (double)blockPosition.m_123342_() + 0.5, (double)blockPosition.m_123343_() + 0.5);
    }

    public static Vec3 vec3(Vector3f vector) {
        return new Vec3((double)vector.x(), (double)vector.y(), (double)vector.z());
    }

    public static Vec3 vec3(Vector3d vector) {
        return new Vec3(vector.x, vector.y, vector.z);
    }

    public static Vector3f vec3f(BlockPos blockPosition) {
        return new Vector3f((float)blockPosition.m_123341_() + 0.5f, (float)blockPosition.m_123342_() + 0.5f, (float)blockPosition.m_123343_() + 0.5f);
    }

    public static Vector3f vec3f(Vec3 vector) {
        return new Vector3f((float)vector.f_82479_, (float)vector.f_82480_, (float)vector.f_82481_);
    }

    public static Vector3f vec3f(Vector3d vector) {
        return new Vector3f((float)vector.x, (float)vector.y, (float)vector.z);
    }

    public static Vector3d vec3d(BlockPos blockPosition) {
        return new Vector3d((double)blockPosition.m_123341_() + 0.5, (double)blockPosition.m_123342_() + 0.5, (double)blockPosition.m_123343_() + 0.5);
    }

    public static Vector3d vec3d(Vec3 vector) {
        return new Vector3d(vector.f_82479_, vector.f_82480_, vector.f_82481_);
    }

    public static Vector3d vec3d(Vector3f vector) {
        return new Vector3d((double)vector.x(), (double)vector.y(), (double)vector.z());
    }
}

