/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.mixin;

import com.mlib.events.ItemHurtEvent;
import com.mlib.gamemodifiers.contexts.OnFoodPropertiesGet;
import com.mlib.gamemodifiers.contexts.OnItemAttributeTooltip;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class MixinItemStack
extends CapabilityProvider<ItemStack>
implements IForgeItemStack {
    protected MixinItemStack(Class<ItemStack> baseClass, boolean isLazy) {
        super(baseClass, isLazy);
    }

    public FoodProperties getFoodProperties(@Nullable LivingEntity entity) {
        OnFoodPropertiesGet.Data data = new OnFoodPropertiesGet.Data(super.getFoodProperties(entity), (ItemStack)this, entity);
        OnFoodPropertiesGet.broadcast(data);
        return data.properties;
    }

    @Shadow(aliases={"this$0"})
    @Inject(method={"hurt(ILnet/minecraft/util/RandomSource;Lnet/minecraft/server/level/ServerPlayer;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void hurt(int damage, RandomSource source, @Nullable ServerPlayer player, CallbackInfoReturnable<Boolean> callback) {
        ItemStack itemStack = (ItemStack)this;
        ItemHurtEvent itemHurtEvent = new ItemHurtEvent(player, itemStack, damage);
        MinecraftForge.EVENT_BUS.post((Event)itemHurtEvent);
        if (itemHurtEvent.extraDamage != 0) {
            itemStack.m_41721_(itemStack.m_41773_() + itemHurtEvent.extraDamage);
        }
        callback.setReturnValue((Object)itemHurtEvent.hasBeenBroken());
    }

    @Shadow(aliases={"this$0"})
    @ModifyVariable(method={"getTooltipLines(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hasTag()Z", ordinal=1))
    private List<Component> getTooltipLines(List<Component> components) {
        OnItemAttributeTooltip.Data data = new OnItemAttributeTooltip.Data((ItemStack)this);
        OnItemAttributeTooltip.Context.accept(data);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            List<Component> slotComponents = data.components.get(slot);
            if (slotComponents.isEmpty()) continue;
            int insertIdx = this.getInsertIdx(components, slot);
            if (insertIdx == -1) {
                components.add(CommonComponents.f_237098_);
                components.add((Component)Component.m_237115_((String)this.getModifierId(slot)).m_130940_(ChatFormatting.GRAY));
                components.addAll(slotComponents);
                continue;
            }
            components.addAll(insertIdx, slotComponents);
        }
        return components;
    }

    private int getInsertIdx(List<Component> components, EquipmentSlot slot) {
        for (int idx = 0; idx < components.size(); ++idx) {
            if (!components.get(idx).toString().contains(this.getModifierId(slot))) continue;
            for (int subIdx = idx + 1; subIdx < components.size(); ++subIdx) {
                if (!components.get(subIdx).toString().contains("item.modifiers")) continue;
                return subIdx + 1;
            }
            return components.size();
        }
        return -1;
    }

    private String getModifierId(EquipmentSlot slot) {
        return String.format("item.modifiers.%s", slot.m_20751_());
    }
}

