/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.mixin;

import com.mlib.events.ItemSwingDurationEvent;
import com.mlib.gamemodifiers.contexts.OnPreDamaged;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity {
    float mlibLastExtraDamage = 0.0f;

    @Shadow(aliases={"this$0"})
    @Inject(method={"getCurrentSwingDuration ()I"}, at={@At(value="RETURN")}, cancellable=true)
    private void getCurrentSwingDuration(CallbackInfoReturnable<Integer> callback) {
        LivingEntity livingEntity = (LivingEntity)this;
        ItemSwingDurationEvent event = new ItemSwingDurationEvent(livingEntity, (Integer)callback.getReturnValue());
        MinecraftForge.EVENT_BUS.post((Event)event);
        callback.setReturnValue((Object)event.getTotalSwingDuration());
    }

    @Shadow(aliases={"this$0"})
    @Inject(method={"hurt (Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void hurt(DamageSource source, float damage, CallbackInfoReturnable<Boolean> callback) {
        this.mlibLastExtraDamage = 0.0f;
        OnPreDamaged.Data data = new OnPreDamaged.Data(source, (LivingEntity)this, damage);
        if (MixinLivingEntity.willBeCancelled(data)) {
            return;
        }
        OnPreDamaged.Context.accept(data);
        if (data.isCancelled) {
            callback.setReturnValue((Object)false);
        } else {
            this.mlibLastExtraDamage = data.extraDamage;
            MixinLivingEntity.tryToAddMagicParticles(data);
        }
    }

    @Shadow(aliases={"this$0"})
    @ModifyVariable(method={"hurt (Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD", shift=At.Shift.AFTER), ordinal=0)
    private float addExtraDamage(float damage) {
        return damage + this.mlibLastExtraDamage;
    }

    private static void tryToAddMagicParticles(OnPreDamaged.Data data) {
        LivingEntity livingEntity = data.attacker;
        if (livingEntity instanceof Player) {
            MobType type;
            Player player = (Player)livingEntity;
            Entity entity = data.source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                v0 = entity2.m_6336_();
            } else {
                v0 = type = MobType.f_21640_;
            }
            if (EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)type) > 0.0f) {
                return;
            }
            if (data.spawnCriticalParticles) {
                player.m_5704_((Entity)data.target);
            }
            if (data.spawnMagicParticles) {
                player.m_5700_((Entity)data.target);
            }
        }
    }

    private static boolean willBeCancelled(OnPreDamaged.Data data) {
        boolean isInvulnerable = data.target.m_6673_(data.source);
        boolean isClientSide = data.level == null;
        boolean isDeadOrDying = data.target.m_21224_();
        boolean isFireResistant = data.source.m_19384_() && data.target.m_21023_(MobEffects.f_19607_);
        return isInvulnerable || isClientSide || isDeadOrDying || isFireResistant;
    }
}

