/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.tests;

import com.mlib.animations.Animation;
import com.mlib.animations.Frame;
import com.mlib.animations.InterpolationType;
import com.mlib.tests.BaseTest;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraftforge.gametest.GameTestHolder;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@GameTestHolder(value="mlib")
public class AnimationTests
extends BaseTest {
    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void applyFloat(GameTestHelper helper) {
        Animation<Float> anim = new Animation<Float>(2.0);
        anim.add(0.0f, new Frame.Value(0.0f)).add(1.0f, new Frame.Value(5.0f)).add(2.0f, new Frame.Value(20.0f));
        AnimationTests.assertThat(helper, ((Float)anim.apply(0.0f, 0.0f)).floatValue(), 0.0f);
        AnimationTests.assertThat(helper, ((Float)anim.apply(0.5f, 0.0f)).floatValue(), 2.5f);
        AnimationTests.assertThat(helper, ((Float)anim.apply(0.5f, 0.5f)).floatValue(), ((Float)anim.apply(0.5f, 1.5f)).floatValue());
        AnimationTests.assertThat(helper, ((Float)anim.apply(0.5f, 0.5f)).floatValue(), 2.5625f);
        AnimationTests.assertThat(helper, ((Float)anim.apply(0.5f, 1.5f)).floatValue(), 2.5625f);
        AnimationTests.assertThat(helper, ((Float)anim.apply(1.0f, 1.0f)).floatValue(), 5.0f);
        AnimationTests.assertThat(helper, ((Float)anim.apply(1.5f, 2.0f)).floatValue(), 12.5f);
        AnimationTests.assertThat(helper, ((Float)anim.apply(2.0f, 2.0f)).floatValue(), 20.0f);
        AnimationTests.assertThat(helper, ((Float)anim.apply(2.0f, 2.137f)).floatValue(), 20.0f);
        AnimationTests.assertThat(helper, ((Float)anim.apply(2.5f, 3.0f)).floatValue(), 20.0f);
        helper.m_177412_();
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void applyDegrees(GameTestHelper helper) {
        Animation<Float> anim = new Animation<Float>(3.0);
        anim.add(0.0f, new Frame.Degrees(0.0f)).add(1.0f, new Frame.Degrees(30.0f, InterpolationType.SMOOTH)).add(2.0f, new Frame.Degrees(90.0f, InterpolationType.SQUARE)).add(3.0f, new Frame.Degrees(180.0f, InterpolationType.CUBE_ROOT));
        AnimationTests.assertThat(helper, ((Float)anim.apply(0.0f, 0.0f)).floatValue(), 0.0f);
        AnimationTests.assertThat(helper, ((Float)anim.apply(0.4f, 0.0f)).floatValue(), 0.18430677f);
        AnimationTests.assertThat(helper, ((Float)anim.apply(1.0f, 0.0f)).floatValue(), 0.5235988f);
        AnimationTests.assertThat(helper, ((Float)anim.apply(1.5f, 0.0f)).floatValue(), 0.7853982f);
        AnimationTests.assertThat(helper, ((Float)anim.apply(2.25f, 0.0f)).floatValue(), (float)Math.PI / 180 * (90.0f + (float)Math.pow(0.25, 0.3333333333333333) * 90.0f));
        AnimationTests.assertThat(helper, ((Float)anim.apply(3.0f, 0.0f)).floatValue(), (float)Math.PI);
        helper.m_177412_();
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void applyVector(GameTestHelper helper) {
        Animation<Vector3f> anim = new Animation<Vector3f>(3.0);
        anim.add(0.0f, new Frame.Vector(0.0f, 0.0f, 0.0f)).add(1.0f, new Frame.Vector(0.0f, 30.0f, 0.0f)).add(2.0f, new Frame.Vector(90.0f, 90.0f, 0.0f)).add(3.0f, new Frame.Vector(180.0f, 180.0f, 180.0f));
        AnimationTests.assertThat(helper, (Vector3f)anim.apply(0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f));
        AnimationTests.assertThat(helper, (Vector3f)anim.apply(0.4f, 0.0f), new Vector3f(0.0f, 12.0f, 0.0f));
        AnimationTests.assertThat(helper, (Vector3f)anim.apply(1.0f, 0.0f), new Vector3f(0.0f, 30.0f, 0.0f));
        AnimationTests.assertThat(helper, (Vector3f)anim.apply(1.5f, 0.0f), new Vector3f(45.0f, 60.0f, 0.0f));
        AnimationTests.assertThat(helper, (Vector3f)anim.apply(2.25f, 0.0f), new Vector3f(112.5f, 112.5f, 45.0f));
        AnimationTests.assertThat(helper, (Vector3f)anim.apply(3.0f, 0.1f), new Vector3f(180.0f, 180.0f, 180.0f));
        helper.m_177412_();
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void interpolate(GameTestHelper helper) {
        AnimationTests.assertThat(helper, 0.0f, 0.0f, InterpolationType.LINEAR);
        AnimationTests.assertThat(helper, 0.25f, 0.25f, InterpolationType.LINEAR);
        AnimationTests.assertThat(helper, 0.5f, 0.5f, InterpolationType.LINEAR);
        AnimationTests.assertThat(helper, 0.75f, 0.75f, InterpolationType.LINEAR);
        AnimationTests.assertThat(helper, 1.0f, 1.0f, InterpolationType.LINEAR);
        AnimationTests.assertThat(helper, 0.0f, 0.0f, InterpolationType.SQUARE);
        AnimationTests.assertThat(helper, 0.25f, 0.0625f, InterpolationType.SQUARE);
        AnimationTests.assertThat(helper, 0.5f, 0.25f, InterpolationType.SQUARE);
        AnimationTests.assertThat(helper, 0.75f, 0.5625f, InterpolationType.SQUARE);
        AnimationTests.assertThat(helper, 1.0f, 1.0f, InterpolationType.SQUARE);
        AnimationTests.assertThat(helper, 0.0f, 0.0f, InterpolationType.SQUARE_ROOT);
        AnimationTests.assertThat(helper, 0.25f, 0.5f, InterpolationType.SQUARE_ROOT);
        AnimationTests.assertThat(helper, 0.5f, 0.707f, InterpolationType.SQUARE_ROOT);
        AnimationTests.assertThat(helper, 0.75f, 0.866f, InterpolationType.SQUARE_ROOT);
        AnimationTests.assertThat(helper, 1.0f, 1.0f, InterpolationType.SQUARE_ROOT);
        AnimationTests.assertThat(helper, 0.0f, 0.0f, InterpolationType.CUBE);
        AnimationTests.assertThat(helper, 0.25f, 0.0156f, InterpolationType.CUBE);
        AnimationTests.assertThat(helper, 0.5f, 0.125f, InterpolationType.CUBE);
        AnimationTests.assertThat(helper, 0.75f, 0.4218f, InterpolationType.CUBE);
        AnimationTests.assertThat(helper, 1.0f, 1.0f, InterpolationType.CUBE);
        AnimationTests.assertThat(helper, 0.0f, 0.0f, InterpolationType.CUBE_ROOT);
        AnimationTests.assertThat(helper, 0.25f, 0.6299f, InterpolationType.CUBE_ROOT);
        AnimationTests.assertThat(helper, 0.5f, 0.7937f, InterpolationType.CUBE_ROOT);
        AnimationTests.assertThat(helper, 0.75f, 0.9085f, InterpolationType.CUBE_ROOT);
        AnimationTests.assertThat(helper, 1.0f, 1.0f, InterpolationType.CUBE_ROOT);
        AnimationTests.assertThat(helper, 0.0f, 0.0f, InterpolationType.SMOOTH);
        AnimationTests.assertThat(helper, 0.25f, 0.15625f, InterpolationType.SMOOTH);
        AnimationTests.assertThat(helper, 0.5f, 0.5f, InterpolationType.SMOOTH);
        AnimationTests.assertThat(helper, 0.75f, 0.8437f, InterpolationType.SMOOTH);
        AnimationTests.assertThat(helper, 1.0f, 1.0f, InterpolationType.SMOOTH);
        helper.m_177412_();
    }

    private static void assertThat(GameTestHelper helper, float result, float expected) {
        if ((double)Math.abs(expected - result) > 0.001) {
            helper.m_177284_("Animation< Float > returns invalid value (result: %s, expected: %s)".formatted(Float.valueOf(result), Float.valueOf(expected)));
        }
    }

    private static void assertThat(GameTestHelper helper, Vector3f result, Vector3f expected) {
        if (!result.equals((Vector3fc)expected, 0.001f)) {
            helper.m_177284_("Animation< Vector > returns invalid value (result: %s, expected: %s)".formatted(result, expected));
        }
    }

    private static void assertThat(GameTestHelper helper, float value, float expected, InterpolationType type) {
        float result = type.apply(value);
        if ((double)Math.abs(expected - result) > 0.001) {
            helper.m_177284_("InterpolationType %s returns invalid value (result: %s, expected: %s)".formatted(type.toString(), Float.valueOf(result), Float.valueOf(expected)));
        }
    }

    public AnimationTests() {
        super(AnimationTests.class);
    }
}

