/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.tests;

import com.mlib.annotations.AnnotationHandler;
import com.mlib.tests.BaseTest;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraftforge.gametest.GameTestHolder;

@GameTestHolder(value="mlib")
public class AnnotationHandlerTests
extends BaseTest {
    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void constructor(GameTestHelper helper) {
        AnnotationHandler handler = new AnnotationHandler("mlib", TestAnnotation1.class);
        AnnotationHandlerTests.assertThat(helper, handler.getInstances().size(), 1, () -> "AnnotationHandler does not load TestClass1 properly");
        helper.m_177412_();
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void missingConstructor(GameTestHelper helper) {
        AnnotationHandler handler = new AnnotationHandler("mlib", TestAnnotation2.class);
        AnnotationHandlerTests.assertThat(helper, handler.getInstances().size(), 1, () -> "AnnotationHandler does not load TestClass2 because of missing explicit constructor");
        helper.m_177412_();
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void inheritance(GameTestHelper helper) {
        AnnotationHandler handler = new AnnotationHandler("mlib", TestAnnotation3.class);
        AnnotationHandlerTests.assertThat(helper, handler.getInstances().size(), 2, () -> "AnnotationHandler does not TestClass3A and TestClass3B properly");
        AnnotationHandlerTests.assertThat(helper, handler.getInstances(TestClass3A.class).size(), 2, () -> "AnnotationHandler does not return valid list of TestClass3A instances");
        AnnotationHandlerTests.assertThat(helper, handler.getInstances(TestClass3B.class).size(), 1, () -> "AnnotationHandler does not return valid list of TestClass3B instances");
        helper.m_177412_();
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void innerClass(GameTestHelper helper) {
        AnnotationHandler handler = new AnnotationHandler("mlib", TestAnnotation4.class);
        AnnotationHandlerTests.assertThat(helper, handler.getInstances().size(), 2, () -> "AnnotationHandler does not handle inner classes properly");
        helper.m_177412_();
    }

    public AnnotationHandlerTests() {
        super(AnnotationHandlerTests.class);
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestAnnotation1 {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestAnnotation2 {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestAnnotation3 {
    }

    @TestAnnotation3
    public static class TestClass3A {
    }

    @TestAnnotation3
    public static class TestClass3B
    extends TestClass3A {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestAnnotation4 {
    }

    @TestAnnotation4
    public static class TestClass4A {

        @TestAnnotation4
        public static class TestClass4B {
        }
    }

    @TestAnnotation2
    public static class TestClass2 {
    }

    @TestAnnotation1
    public static class TestClass1 {
    }
}

