/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.tests;

import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ContextData;
import com.mlib.gamemodifiers.Contexts;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.tests.BaseTest;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraftforge.gametest.GameTestHolder;
import org.apache.commons.lang3.mutable.MutableInt;

@GameTestHolder(value="mlib")
public class ConditionTests
extends BaseTest {
    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void priority(GameTestHelper helper) {
        Contexts.getInstances().forEach(contexts -> contexts.getContexts().forEach(context -> {
            MutableInt max = new MutableInt(Integer.MIN_VALUE);
            context.getConditions().forEach(condition -> {
                int priority = condition.getParams().getPriorityAsInt();
                ConditionTests.assertThat(helper, priority >= max.getValue(), () -> "%s has invalid priority in %s".formatted(ConditionTests.getClassName(condition), ConditionTests.getClassName(context)));
                max.setValue(priority);
            });
        }));
        helper.m_177412_();
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void validParameters(GameTestHelper helper) {
        Contexts.getInstances().forEach(contexts -> contexts.getContexts().forEach(context -> context.getConditions().forEach(condition -> {
            boolean isConfigurable = condition.getParams().isConfigurable();
            boolean doesNotHaveConfigs = condition.getConfigs().isEmpty();
            ConditionTests.assertThat(helper, !isConfigurable || !doesNotHaveConfigs, () -> "%s is marked configurable even though it does not have any config".formatted(ConditionTests.getClassName(condition)));
        })));
        Condition<ContextData> condition = new Condition<ContextData>(){

            @Override
            public boolean check(GameModifier feature, ContextData data) {
                return true;
            }
        };
        ConditionTests.assertThat(helper, condition.isMet(null, null), () -> "%s does not return expected result".formatted(ConditionTests.getClassName(condition)));
        condition.negate();
        ConditionTests.assertThat(helper, !condition.isMet(null, null), () -> "%s does not return expected negated result".formatted(ConditionTests.getClassName(condition)));
        helper.m_177412_();
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void builtConfigs(GameTestHelper helper) {
        Contexts.getInstances().forEach(contexts -> contexts.getContexts().forEach(context -> context.getConditions().forEach(condition -> {
            boolean isConfigurable = condition.getParams().isConfigurable();
            boolean isConditionBuilt = condition.isBuilt();
            boolean areConditionConfigsBuilt = condition.getConfigs().stream().allMatch(IConfigurable::isBuilt);
            ConditionTests.assertThat(helper, !isConfigurable || isConditionBuilt && areConditionConfigsBuilt, () -> "Some of the configs in %s has not been built".formatted(ConditionTests.getClassName(condition)));
        })));
        helper.m_177412_();
    }

    public ConditionTests() {
        super(ConditionTests.class);
    }
}

