/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.tests;

import com.mlib.math.Range;
import com.mlib.tests.BaseTest;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraftforge.gametest.GameTestHolder;

@GameTestHolder(value="mlib")
public class RangeTests
extends BaseTest {
    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void within(GameTestHelper helper) {
        RangeTests.assertThat(helper, new Range<Float>(Float.valueOf(1.0f), Float.valueOf(1.2f)), Float.valueOf(0.9999f), false);
        RangeTests.assertThat(helper, new Range<Float>(Float.valueOf(0.9f), Float.valueOf(1.0f)), Float.valueOf(0.9999f), true);
        RangeTests.assertThat(helper, new Range<Float>(Float.valueOf(-1.0f), Float.valueOf(0.2f)), Float.valueOf(0.2f), true);
        RangeTests.assertThat(helper, new Range<Float>(Float.valueOf(-1.2f), Float.valueOf(0.0f)), Float.valueOf(-1.2001f), false);
        RangeTests.assertThat(helper, new Range<Double>(1.0, 1.2), Double.valueOf(0.9999), false);
        RangeTests.assertThat(helper, new Range<Double>(0.9, 1.0), Double.valueOf(0.9999), true);
        RangeTests.assertThat(helper, new Range<Double>(-1.0, 0.2), Double.valueOf(0.2), true);
        RangeTests.assertThat(helper, new Range<Double>(-1.2, 0.0), Double.valueOf(-1.2001), false);
        RangeTests.assertThat(helper, new Range<Integer>(1, 5), Integer.valueOf(0), false);
        RangeTests.assertThat(helper, new Range<Integer>(0, 4), Integer.valueOf(3), true);
        RangeTests.assertThat(helper, new Range<Integer>(-5, -1), Integer.valueOf(-1), true);
        RangeTests.assertThat(helper, new Range<Integer>(-8, -8), Integer.valueOf(-9), false);
        helper.m_177412_();
    }

    private static <Type extends Number> void assertThat(GameTestHelper helper, Range<Type> range, Type value, boolean expected) {
        boolean result = range.within(value);
        RangeTests.assertThat(helper, result == expected, () -> "Range.within() returns invalid result (result: %s, expected: %s)".formatted(result, expected));
    }

    public RangeTests() {
        super(RangeTests.class);
    }
}

