/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.tests;

import com.mlib.tests.BaseTest;
import com.mlib.time.Delay;
import com.mlib.time.ISuspendedExecution;
import com.mlib.time.Slider;
import com.mlib.time.Time;
import com.mlib.time.Until;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraftforge.gametest.GameTestHolder;

@GameTestHolder(value="mlib")
public class SuspendedExecutionTests
extends BaseTest {
    static final int DELAY = 4;

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void interfacee(final GameTestHelper helper) {
        ISuspendedExecution exec = new ISuspendedExecution(){
            public int startTick;
            public int ticksLeft = 4;
            public int endTick;

            @Override
            public void onStart() {
                this.startTick = BaseTest.getTickCount(helper);
            }

            @Override
            public void onTick() {
                --this.ticksLeft;
            }

            @Override
            public void onEnd() {
                this.endTick = BaseTest.getTickCount(helper);
            }

            @Override
            public boolean isFinished() {
                return this.ticksLeft == 0;
            }
        };
        Time.setup(exec);
        helper.m_177410_(() -> SuspendedExecutionTests.lambda$interfacee$1(exec, helper));
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void delay(GameTestHelper helper) {
        Delay delay = Time.delay(4, _delay -> {});
        int startTick = SuspendedExecutionTests.getTickCount(helper);
        helper.m_177410_(() -> {
            if (!delay.isFinished()) {
                return;
            }
            int endTick = SuspendedExecutionTests.getTickCount(helper);
            SuspendedExecutionTests.assertThat(helper, endTick - startTick, 4, () -> "Delay does not handle ticks properly");
            helper.m_177412_();
        });
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void slider(GameTestHelper helper) {
        AtomicInteger counter = new AtomicInteger(0);
        Slider slider = Time.slider(4, _delay -> counter.set(counter.get() + 1));
        int startTick = SuspendedExecutionTests.getTickCount(helper);
        helper.m_177410_(() -> {
            if (!slider.isFinished()) {
                return;
            }
            int endTick = SuspendedExecutionTests.getTickCount(helper);
            SuspendedExecutionTests.assertThat(helper, endTick - startTick, 4, () -> "Slider does not handle ticks properly");
            SuspendedExecutionTests.assertThat(helper, counter.get(), 5, () -> "Slider callback should be called as many times as the delay ticks plus one");
            helper.m_177412_();
        });
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void until(GameTestHelper helper) {
        AtomicInteger counter = new AtomicInteger(0);
        Until until = Time.until(() -> counter.updateAndGet(x -> x + 1) >= 8, _delay -> {});
        int startTick = SuspendedExecutionTests.getTickCount(helper);
        helper.m_177410_(() -> {
            if (!until.isFinished()) {
                return;
            }
            int endTick = SuspendedExecutionTests.getTickCount(helper);
            SuspendedExecutionTests.assertThat(helper, endTick - startTick, 4, () -> "Until does not handle ticks properly");
            helper.m_177412_();
        });
    }

    public SuspendedExecutionTests() {
        super(SuspendedExecutionTests.class);
    }

    private static /* synthetic */ void lambda$interfacee$1(1 exec, GameTestHelper helper) {
        if (!exec.isFinished()) {
            return;
        }
        SuspendedExecutionTests.assertThat(helper, exec.endTick - exec.startTick + 1, 4, () -> "Suspended execution does not handle ticks properly");
        helper.m_177412_();
    }
}

