/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.tests;

import com.mlib.tests.BaseTest;
import com.mlib.text.TextHelper;
import java.util.function.Function;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraftforge.gametest.GameTestHolder;

@GameTestHolder(value="mlib")
public class TextHelperTests
extends BaseTest {
    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void romanLetters(GameTestHelper helper) {
        String name = "TextHelper.toRoman()";
        TextHelperTests.assertThat(helper, "I", 1, TextHelper::toRoman, name);
        TextHelperTests.assertThat(helper, "IV", 4, TextHelper::toRoman, name);
        TextHelperTests.assertThat(helper, "XI", 11, TextHelper::toRoman, name);
        TextHelperTests.assertThat(helper, "XVIII", 18, TextHelper::toRoman, name);
        TextHelperTests.assertThat(helper, "XCIX", 99, TextHelper::toRoman, name);
        TextHelperTests.assertThat(helper, "CLV", 155, TextHelper::toRoman, name);
        helper.m_177412_();
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void minPrecision(GameTestHelper helper) {
        String name = "TextHelper.minPrecision()";
        TextHelperTests.assertThat(helper, "1", Float.valueOf(1.0f), TextHelper::minPrecision, name);
        TextHelperTests.assertThat(helper, "3.9", Float.valueOf(3.9f), TextHelper::minPrecision, name);
        TextHelperTests.assertThat(helper, "5", Float.valueOf(5.001f), TextHelper::minPrecision, name);
        TextHelperTests.assertThat(helper, "7", Float.valueOf(7.00009f), TextHelper::minPrecision, name);
        TextHelperTests.assertThat(helper, "9.91", Float.valueOf(9.9099f), TextHelper::minPrecision, name);
        TextHelperTests.assertThat(helper, "11.11", Float.valueOf(11.11f), TextHelper::minPrecision, name);
        helper.m_177412_();
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void signed(GameTestHelper helper) {
        String name = "TextHelper.signed()";
        TextHelperTests.assertThat(helper, "+1", Float.valueOf(1.0f), TextHelper::signed, name);
        TextHelperTests.assertThat(helper, "+0", Float.valueOf(0.0f), TextHelper::signed, name);
        TextHelperTests.assertThat(helper, "-1.01", Float.valueOf(-1.01f), TextHelper::signed, name);
        TextHelperTests.assertThat(helper, "+1", 1, TextHelper::signed, name);
        TextHelperTests.assertThat(helper, "+0", 0, TextHelper::signed, name);
        TextHelperTests.assertThat(helper, "-1", -1, TextHelper::signed, name);
        helper.m_177412_();
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void signedPercent(GameTestHelper helper) {
        String name = "TextHelper.signedPercent()";
        TextHelperTests.assertThat(helper, "+101%", Float.valueOf(1.01f), TextHelper::signedPercent, name);
        TextHelperTests.assertThat(helper, "+1.1%", Float.valueOf(0.011f), TextHelper::signedPercent, name);
        TextHelperTests.assertThat(helper, "-200%", Float.valueOf(-1.999999f), TextHelper::signedPercent, name);
        TextHelperTests.assertThat(helper, "+100%", 1, TextHelper::signedPercent, name);
        TextHelperTests.assertThat(helper, "+0%", 0, TextHelper::signedPercent, name);
        TextHelperTests.assertThat(helper, "-100%", -1, TextHelper::signedPercent, name);
        helper.m_177412_();
    }

    @GameTest(templateNamespace="mlib", template="empty_test")
    public static void percent(GameTestHelper helper) {
        String name = "TextHelper.percent()";
        TextHelperTests.assertThat(helper, "99%", Float.valueOf(0.99f), TextHelper::percent, name);
        TextHelperTests.assertThat(helper, "0.01%", Float.valueOf(1.0E-4f), TextHelper::percent, name);
        TextHelperTests.assertThat(helper, "-100%", -1, TextHelper::percent, name);
        helper.m_177412_();
    }

    private static <Type extends Number> void assertThat(GameTestHelper helper, String text, Type value, Function<Type, String> function, String functionName) {
        TextHelperTests.assertThat(helper, text, function.apply(value), () -> "%s does not give proper output".formatted(functionName));
    }

    public TextHelperTests() {
        super(TextHelperTests.class);
    }
}

