/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty;

import com.majruszsdifficulty.gamemodifiers.contexts.OnGameStageChange;
import com.mlib.levels.LevelHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public enum GameStage {
    NORMAL(ChatFormatting.WHITE),
    EXPERT(ChatFormatting.RED, ChatFormatting.BOLD),
    MASTER(ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD);

    private static GameStage CURRENT;
    final ChatFormatting[] formatting;

    private GameStage(ChatFormatting ... formatting) {
        this.formatting = formatting;
    }

    public ChatFormatting[] getChatFormatting() {
        return this.formatting;
    }

    public static boolean changeStage(GameStage stage, @Nullable MinecraftServer server) {
        if (stage != CURRENT) {
            GameStage previous = CURRENT;
            CURRENT = stage;
            OnGameStageChange.accept(new OnGameStageChange.Data(server, previous, CURRENT));
            return true;
        }
        return false;
    }

    public static GameStage getCurrentStage() {
        return CURRENT;
    }

    public static boolean atLeast(GameStage stage) {
        return CURRENT.ordinal() >= stage.ordinal();
    }

    public static GameStage convertIntegerToStage(int mode) {
        return switch (mode) {
            default -> NORMAL;
            case 1 -> EXPERT;
            case 2 -> MASTER;
        };
    }

    public static <Type> Type getGameStageDependentValue(GameStage stage, Type normal, Type expert, Type master) {
        return switch (stage) {
            default -> normal;
            case EXPERT -> expert;
            case MASTER -> master;
        };
    }

    public static <Type> Type getCurrentGameStageDependentValue(Type normal, Type expert, Type master) {
        return GameStage.getGameStageDependentValue(CURRENT, normal, expert, master);
    }

    public static MutableComponent getGameStageText(GameStage stage) {
        return Component.m_237115_((String)("majruszsdifficulty.stages." + stage.name().toLowerCase())).m_130944_(stage.formatting);
    }

    public static double getRegionalDifficulty(Entity target) {
        double clampedRegionalDifficulty = target != null ? LevelHelper.getClampedRegionalDifficulty((Entity)target) : 0.25;
        return Mth.m_14008_((double)(clampedRegionalDifficulty + GameStage.getStageModifier()), (double)0.0, (double)1.0);
    }

    public static double getRegionalDifficulty(Level level, Vec3 position) {
        double clampedRegionalDifficulty = LevelHelper.getClampedRegionalDifficulty((Level)level, (Vec3)position);
        return Mth.m_14008_((double)(clampedRegionalDifficulty + GameStage.getStageModifier()), (double)0.0, (double)1.0);
    }

    public static double getStageModifier() {
        return GameStage.getCurrentGameStageDependentValue(0.0, 0.15, 0.3);
    }

    static {
        CURRENT = NORMAL;
    }

    public record Double(double normal, double expert, double master) {
        public Double(double value) {
            this(value, value, value);
        }
    }

    public record Integer(int normal, int expert, int master) {
        public Integer(int value) {
            this(value, value, value);
        }
    }
}

