/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects;

import com.majruszsdifficulty.PacketHandler;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.configs.BleedingConfig;
import com.majruszsdifficulty.gamemodifiers.contexts.OnBleedingCheck;
import com.majruszsdifficulty.gui.BleedingGui;
import com.mlib.EquipmentSlots;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.BooleanConfig;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.config.StringListConfig;
import com.mlib.effects.ParticleHandler;
import com.mlib.entities.EntityHelper;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnDamaged;
import com.mlib.gamemodifiers.contexts.OnDeath;
import com.mlib.gamemodifiers.contexts.OnEffectApplicable;
import com.mlib.gamemodifiers.contexts.OnEntityTick;
import com.mlib.gamemodifiers.contexts.OnItemAttributeTooltip;
import com.mlib.mobeffects.MobEffectHelper;
import com.mlib.network.NetworkMessage;
import com.mlib.text.TextHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class BleedingEffect
extends MobEffect {
    static Supplier<Boolean> IS_ENABLED = () -> true;
    static Supplier<Integer> GET_AMPLIFIER = () -> 0;
    static Function<EquipmentSlot, Float> GET_ARMOR_MULTIPLIER = slot -> Float.valueOf(1.0f);

    public static boolean isEnabled() {
        return IS_ENABLED.get();
    }

    public static int getAmplifier() {
        return GET_AMPLIFIER.get();
    }

    public BleedingEffect() {
        super(MobEffectCategory.HARMFUL, -2271915);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
    }

    public void m_19461_(@Nullable Entity source, @Nullable Entity indirectSource, LivingEntity entity, int amplifier, double health) {
    }

    public boolean m_6584_(int duration, int amplifier) {
        return false;
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    public static class BloodMessage
    extends NetworkMessage {
        final int entityId;

        public BloodMessage(Entity entity) {
            this.entityId = this.write(entity);
        }

        public BloodMessage(FriendlyByteBuf buffer) {
            this.entityId = this.readEntity(buffer);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void receiveMessage(NetworkEvent.Context context) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null && minecraft.f_91073_.m_6815_(this.entityId) == minecraft.f_91074_) {
                BleedingGui.addBloodOnScreen(3);
            }
        }
    }

    @AutoInstance
    public static class Bleeding
    extends GameModifier {
        static final ParticleHandler PARTICLES = new ParticleHandler(Registries.BLOOD, () -> new Vec3(0.2, 0.5, 0.2), ParticleHandler.speed((float)0.075f));
        static final String ATTRIBUTE_ID = "effect.majruszsdifficulty.bleeding.armor_tooltip";
        static final int BLOOD_TICK_COOLDOWN = Utility.secondsToTicks((double)4.0);
        final StringListConfig immuneMobs = new StringListConfig(new String[]{"minecraft:skeleton_horse", "minecraft:zombie_horse"});
        final BleedingConfig effect = new BleedingConfig();
        final HashMap<Integer, Integer> entityTicks = new HashMap();

        public Bleeding() {
            super(Registries.Modifiers.DEFAULT);
            new OnEntityTick.Context(this::spawnParticles).addCondition((Condition)new Condition.IsServer()).addCondition(new Condition.Cooldown(3, Dist.DEDICATED_SERVER).configurable(false)).addCondition((Condition)new Condition.HasEffect(Registries.BLEEDING)).insertTo((GameModifier)this);
            new OnEntityTick.Context(this::tick).addCondition((Condition)new Condition.IsServer()).addCondition((Condition)new Condition.HasEffect(Registries.BLEEDING)).insertTo((GameModifier)this);
            new OnDeath.Context(this::spawnParticles).addCondition((Condition)new Condition.IsServer()).addCondition((Condition)new Condition.HasEffect(Registries.BLEEDING)).insertTo((GameModifier)this);
            new OnEffectApplicable.Context(this::cancelEffect).addCondition(data -> !BleedingEffect.isEnabled()).addCondition(data -> data.effect.equals(Registries.BLEEDING_IMMUNITY.get())).insertTo((GameModifier)this);
            new OnDamaged.Context(this::applyBleeding).addCondition((Condition)new Condition.IsServer()).addCondition((Condition)new ExcludableBleeding()).addCondition((Condition)new ArmorDependentBleedingChance(0.8, 0.6, 0.7, 0.9)).addCondition(this::isNotImmune).addCondition(OnDamaged.DEALT_ANY_DAMAGE).addConfig((IConfigurable)this.immuneMobs.name("immune_mobs").comment("Specifies which mobs should not be affected by Bleeding (all undead mobs are immune by default).")).addConfig((IConfigurable)this.effect).insertTo((GameModifier)this);
            new OnItemAttributeTooltip.Context(this::addChanceTooltip).addCondition(data -> data.item instanceof ArmorItem).addCondition(data -> BleedingEffect.isEnabled()).insertTo((GameModifier)this);
            GET_AMPLIFIER = this.effect::getAmplifier;
            this.name("Bleeding").comment("Common config for all Bleeding effects.");
        }

        private void spawnParticles(OnEntityTick.Data data) {
            int amplifier = MobEffectHelper.getAmplifier((LivingEntity)data.entity, (MobEffect)((MobEffect)Registries.BLEEDING.get()));
            float walkDistanceDelta = EntityHelper.getWalkDistanceDelta((LivingEntity)data.entity);
            this.spawnParticles(data.level, (Entity)data.entity, Random.roundRandomly((double)(1.0 + (15.0 + (double)amplifier) * (double)walkDistanceDelta)));
        }

        private void tick(OnEntityTick.Data data) {
            LivingEntity entity = data.entity;
            int amplifier = MobEffectHelper.getAmplifier((LivingEntity)entity, (MobEffect)((MobEffect)Registries.BLEEDING.get()));
            int extraDuration = Random.roundRandomly((double)(0.3 * (double)(amplifier + 2) * (7.26 * (double)EntityHelper.getWalkDistanceDelta((LivingEntity)entity) + 1.0)));
            int duration = this.entityTicks.getOrDefault(entity.m_19879_(), 0) + extraDuration;
            if (duration >= BLOOD_TICK_COOLDOWN) {
                this.dealDamage(entity);
                duration = 0;
            }
            this.entityTicks.put(entity.m_19879_(), duration);
        }

        private void dealDamage(LivingEntity entity) {
            net.minecraft.world.effect.MobEffectInstance mobEffectInstance = entity.m_21124_((MobEffect)Registries.BLEEDING.get());
            if (mobEffectInstance instanceof MobEffectInstance) {
                MobEffectInstance effectInstance = (MobEffectInstance)mobEffectInstance;
                Vec3 motion = entity.m_20184_();
                entity.m_6469_((DamageSource)new EntityBleedingDamageSource(effectInstance.damageSourceEntity), 1.0f);
                entity.m_20256_(motion);
            } else {
                entity.m_6469_(Registries.BLEEDING_SOURCE, 1.0f);
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new BloodMessage((Entity)player));
            }
            this.entityTicks.put(entity.m_19879_(), 0);
        }

        private void spawnParticles(OnDeath.Data data) {
            assert (data.entity != null);
            this.spawnParticles(data.level, data.entity, 100);
        }

        private void spawnParticles(ServerLevel level, Entity entity, int amountOfParticles) {
            Vec3 position = new Vec3(entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_());
            PARTICLES.spawn(level, position, amountOfParticles);
        }

        private void cancelEffect(OnEffectApplicable.Data data) {
            ((MobEffectEvent.Applicable)data.event).setResult(Event.Result.DENY);
        }

        private void applyBleeding(OnDamaged.Data data) {
            OnBleedingCheck.Data bleedingData = new OnBleedingCheck.Data((LivingHurtEvent)data.event);
            OnBleedingCheck.Context.accept(bleedingData);
            if (bleedingData.isEffectTriggered() && this.effect.apply(data)) {
                this.dealDamage(data.target);
            }
        }

        private boolean isNotImmune(OnDamaged.Data data) {
            return !this.immuneMobs.contains(Utility.getRegistryString((LivingEntity)data.target));
        }

        private void addChanceTooltip(OnItemAttributeTooltip.Data data) {
            for (EquipmentSlot slot : EquipmentSlots.ARMOR) {
                if (!data.itemStack.m_41638_(slot).containsKey((Object)Attributes.f_22284_)) continue;
                String multiplier = TextHelper.minPrecision((float)GET_ARMOR_MULTIPLIER.apply(slot).floatValue());
                data.add(slot, (Component)Component.m_237110_((String)ATTRIBUTE_ID, (Object[])new Object[]{multiplier}).m_130940_(ChatFormatting.BLUE));
            }
        }

        private static class ExcludableBleeding
        extends Condition.Excludable<OnDamaged.Data> {
            ExcludableBleeding() {
                IS_ENABLED = () -> ((BooleanConfig)this.availability).isEnabled();
            }
        }

        private static class ArmorDependentBleedingChance
        extends Condition.ArmorDependentChance<OnDamaged.Data> {
            ArmorDependentBleedingChance(double headChance, double chestChance, double legsChance, double feetChance) {
                super(headChance, chestChance, legsChance, feetChance);
                GET_ARMOR_MULTIPLIER = slot -> Float.valueOf(((DoubleConfig)this.multipliers.get(slot)).asFloat());
            }
        }
    }

    public static class MobEffectInstance
    extends net.minecraft.world.effect.MobEffectInstance {
        @Nullable
        protected final Entity damageSourceEntity;

        public MobEffectInstance(int duration, int amplifier, boolean ambient, @Nullable LivingEntity attacker) {
            super((MobEffect)Registries.BLEEDING.get(), duration, amplifier, ambient, false, true);
            this.damageSourceEntity = attacker;
        }
    }

    public static class EntityBleedingDamageSource
    extends DamageSource {
        @Nullable
        protected final Entity damageSourceEntity;

        public EntityBleedingDamageSource(@Nullable Entity damageSourceEntity) {
            super(Registries.BLEEDING_SOURCE.f_19326_);
            this.damageSourceEntity = damageSourceEntity;
            this.m_19380_();
        }

        @Nullable
        public Entity m_7640_() {
            return null;
        }

        @Nullable
        public Entity m_7639_() {
            return this.damageSourceEntity;
        }
    }
}

