/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entities;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.majruszsdifficulty.PacketHandler;
import com.majruszsdifficulty.Registries;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.annotations.AutoInstance;
import com.mlib.blocks.BlockHelper;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.config.StringConfig;
import com.mlib.effects.ParticleHandler;
import com.mlib.effects.SoundHandler;
import com.mlib.entities.EntityHelper;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ContextBase;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnEntityTick;
import com.mlib.gamemodifiers.contexts.OnItemTooltip;
import com.mlib.gamemodifiers.contexts.OnLoot;
import com.mlib.gamemodifiers.contexts.OnLootTableCustomLoad;
import com.mlib.gamemodifiers.contexts.OnPreDamaged;
import com.mlib.gamemodifiers.contexts.OnSpawned;
import com.mlib.math.Range;
import com.mlib.math.VectorHelper;
import com.mlib.network.NetworkMessage;
import com.mlib.text.TextHelper;
import com.mlib.time.Time;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class CursedArmorEntity
extends Monster {
    public static final String GROUP_ID = "CursedArmor";
    public static final int ASSEMBLE_DURATION = Utility.secondsToTicks((double)2.5);
    SoundHandler assembleSound = null;
    int assembleTicksLeft = 0;

    public static Supplier<EntityType<CursedArmorEntity>> createSupplier() {
        return () -> EntityType.Builder.m_20704_(CursedArmorEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 1.9f).m_20712_("cursed_armor");
    }

    public static AttributeSupplier getAttributeMap() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22278_, 0.23).m_22268_(Attributes.f_22284_, 4.0).m_22265_();
    }

    public CursedArmorEntity(EntityType<? extends CursedArmorEntity> type, Level world) {
        super(type, world);
    }

    public int m_213860_() {
        return Random.nextInt((int)7);
    }

    public void m_8119_() {
        super.m_8119_();
        this.tryToPlaySfx();
        this.assembleTicksLeft = Math.max(this.assembleTicksLeft - 1, 0);
        if (this.f_21345_.m_148105_().isEmpty()) {
            this.m_8099_();
        }
    }

    public void startAssembling(float yRot) {
        this.assembleTicksLeft = ASSEMBLE_DURATION;
        this.m_146922_(yRot);
        this.m_5616_(yRot);
        this.m_5618_(yRot);
        if (this.f_19853_ instanceof ServerLevel) {
            Time.nextTick(() -> PacketHandler.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()), (Object)new AssembleMessage((Entity)this, yRot)));
        }
    }

    public void setAssembleSound(SoundEvent soundEvent) {
        this.assembleSound = new SoundHandler(soundEvent, SoundSource.HOSTILE, SoundHandler.randomized((float)1.2f));
    }

    public boolean isAssembling() {
        return this.assembleTicksLeft > 0;
    }

    public float getAssembleTime() {
        return (float)Utility.ticksToSeconds((int)(ASSEMBLE_DURATION - this.assembleTicksLeft));
    }

    protected void m_8099_() {
        if (this.isAssembling() || this.f_19797_ <= ASSEMBLE_DURATION / 3) {
            return;
        }
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    private void tryToPlaySfx() {
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (this.assembleTicksLeft == ASSEMBLE_DURATION) {
            SoundHandler.ENCHANT.play((Level)level2, this.m_20182_());
        } else if (this.assembleTicksLeft == ASSEMBLE_DURATION - 75) {
            this.assembleSound.play((Level)level2, this.m_20182_());
        }
    }

    static {
        GameModifier.addNewGroup((String)Registries.Modifiers.MOBS, (String)GROUP_ID).name(GROUP_ID);
    }

    public static class AssembleMessage
    extends NetworkMessage {
        final int entityId;
        final float yRot;

        public AssembleMessage(Entity entity, float yRot) {
            this.entityId = this.write(entity);
            this.yRot = this.write(yRot);
        }

        public AssembleMessage(FriendlyByteBuf buffer) {
            this.entityId = this.readEntity(buffer);
            this.yRot = this.readFloat(buffer);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void receiveMessage(NetworkEvent.Context context) {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (entity = level.m_6815_(this.entityId)) instanceof CursedArmorEntity) {
                CursedArmorEntity cursedArmor = (CursedArmorEntity)entity;
                cursedArmor.startAssembling(this.yRot);
            }
        }
    }

    @AutoInstance
    public static class TooltipUpdater {
        public TooltipUpdater() {
            new OnItemTooltip.Context(this::addSpawnInfo).addCondition(data -> data.itemStack.m_41720_().equals(Registries.CURSED_ARMOR_SPAWN_EGG.get()));
        }

        private void addSpawnInfo(OnItemTooltip.Data data) {
            List components = data.tooltip;
            components.add(Component.m_237115_((String)"item.majruszsdifficulty.cursed_armor_spawn_egg.locations").m_130940_(ChatFormatting.GRAY));
            Spawn.DATA_MAP.forEach((location, spawnData) -> {
                String chance = TextHelper.percent((float)((float)spawnData.chance));
                components.add(Component.m_237113_((String)" - ").m_7220_((Component)Component.m_237113_((String)location.toString())).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237113_((String)chance).m_130940_(ChatFormatting.DARK_GRAY)).m_130940_(ChatFormatting.GRAY));
            });
        }
    }

    @AutoInstance
    public static class Effects {
        public Effects() {
            this.createOnTick(this::spawnIdleParticles);
            this.createOnTick(this::spawnAssemblingParticles).addCondition(data -> {
                CursedArmorEntity cursedArmor;
                LivingEntity patt12111$temp = data.entity;
                return patt12111$temp instanceof CursedArmorEntity && (cursedArmor = (CursedArmorEntity)patt12111$temp).isAssembling();
            });
        }

        private ContextBase<OnEntityTick.Data> createOnTick(Consumer<OnEntityTick.Data> consumer) {
            return new OnEntityTick.Context(consumer).addCondition((Condition)new Condition.IsServer()).addCondition(new Condition.Cooldown(0.2, Dist.DEDICATED_SERVER).configurable(false)).addCondition(data -> data.entity instanceof CursedArmorEntity);
        }

        private void spawnIdleParticles(OnEntityTick.Data data) {
            CursedArmorEntity cursedArmor = (CursedArmorEntity)data.entity;
            this.spawnParticles(data, new Vec3(0.0, (double)cursedArmor.m_20206_() * 0.5, 0.0), 0.3, 1);
        }

        private void spawnAssemblingParticles(OnEntityTick.Data data) {
            this.spawnParticles(data, new Vec3(0.0, 0.0, 0.0), 0.6, 5);
        }

        private void spawnParticles(OnEntityTick.Data data, Vec3 emitterOffset, double offsetMultiplier, int particlesCount) {
            CursedArmorEntity cursedArmor = (CursedArmorEntity)data.entity;
            Vec3 position = cursedArmor.m_20182_().m_82549_(emitterOffset);
            Vec3 offset = VectorHelper.multiply((Vec3)new Vec3((double)cursedArmor.m_20205_(), (double)cursedArmor.m_20206_(), (double)cursedArmor.m_20205_()), (Number)offsetMultiplier);
            ParticleHandler.ENCHANTED_GLYPH.spawn(data.level, position, particlesCount, () -> offset, () -> Float.valueOf(0.5f));
        }
    }

    @AutoInstance
    public static class Spawn
    extends GameModifier {
        static final String MAIN_TAG = "cursed_armor";
        static final String LOOT_TABLE_TAG = "loot";
        static final String SOUND_TAG = "sound";
        static final String CHANCE_TAG = "chance";
        static final Map<ResourceLocation, Data> DATA_MAP = new HashMap<ResourceLocation, Data>();
        final DoubleConfig dropChance = new DoubleConfig(0.1, Range.CHANCE);
        final StringConfig name = new StringConfig("Freshah");

        public Spawn() {
            super(CursedArmorEntity.GROUP_ID);
            new OnLoot.Context(this::spawnCursedArmor).addCondition((Condition)new Condition.IsServer()).addCondition(OnLoot.HAS_ORIGIN).addCondition(data -> BlockHelper.getBlockEntity((Level)data.level, (Vec3)data.origin) instanceof ChestBlockEntity).addCondition(this::hasLootDefined).addConfig((IConfigurable)this.dropChance.name("drop_chance").comment("Chance for each equipped item to drop when killed.")).insertTo((GameModifier)this);
            new OnLootTableCustomLoad.Context(this::loadCursedArmorLoot).addCondition(data -> data.jsonObject.has(MAIN_TAG)).insertTo((GameModifier)this);
            new OnSpawned.Context(this::setCustomName).name("CustomName").comment("Makes some Cursed Armors have a custom name.").addCondition((Condition)new Condition.IsServer()).addCondition((Condition)new Condition.Chance(0.025)).addCondition((Condition)new OnSpawned.IsNotLoadedFromDisk()).addCondition(data -> data.target instanceof CursedArmorEntity).addConfigs(new IConfigurable[]{this.name.name("name")}).insertTo((GameModifier)this);
            new OnSpawned.ContextSafe(this::giveRandomArmor).addCondition((Condition)new Condition.IsServer()).addCondition((Condition)new OnSpawned.IsNotLoadedFromDisk()).addCondition(data -> data.target instanceof CursedArmorEntity).insertTo((GameModifier)this);
            new OnSpawned.Context(this::startAssembling).addCondition((Condition)new OnSpawned.IsNotLoadedFromDisk()).addCondition(data -> {
                CursedArmorEntity cursedArmor;
                LivingEntity patt8067$temp = data.target;
                return patt8067$temp instanceof CursedArmorEntity && !(cursedArmor = (CursedArmorEntity)patt8067$temp).isAssembling();
            }).insertTo((GameModifier)this);
            new OnPreDamaged.Context(OnPreDamaged.CANCEL).addCondition(data -> {
                CursedArmorEntity cursedArmor;
                LivingEntity patt8257$temp = data.target;
                return patt8257$temp instanceof CursedArmorEntity && (cursedArmor = (CursedArmorEntity)patt8257$temp).isAssembling();
            }).insertTo((GameModifier)this);
        }

        private void spawnCursedArmor(OnLoot.Data data) {
            CursedArmorEntity cursedArmor = (CursedArmorEntity)EntityHelper.spawn(Registries.CURSED_ARMOR, (Level)data.level, (Vec3)this.getSpawnPosition(data));
            if (cursedArmor != null) {
                float yRot = ((Direction)BlockHelper.getBlockState((Level)data.level, (Vec3)data.origin).m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
                cursedArmor.startAssembling(yRot);
                this.equipSet(DATA_MAP.get(data.context.getQueriedLootTableId()), cursedArmor, data.origin);
                Entity entity = data.entity;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    Time.nextTick(() -> ((ServerPlayer)player).m_6915_());
                }
            }
        }

        private Vec3 getSpawnPosition(OnLoot.Data data) {
            ServerLevel level = data.level;
            Vec3 origin = data.origin;
            Function<Float, Boolean> isAir = y -> BlockHelper.getBlockState((Level)level, (Vec3)origin.m_82520_(0.0, (double)y.floatValue(), 0.0)).m_60795_();
            if (isAir.apply(Float.valueOf(1.0f)).booleanValue() && isAir.apply(Float.valueOf(2.0f)).booleanValue()) {
                return origin.m_82520_(0.0, 0.5, 0.0);
            }
            Vec3i offset = ((Direction)BlockHelper.getBlockState((Level)data.level, (Vec3)data.origin).m_61143_((Property)ChestBlock.f_51478_)).m_122436_();
            return origin.m_82520_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
        }

        private void loadCursedArmorLoot(OnLootTableCustomLoad.Data data) {
            JsonObject object = data.jsonObject.get(MAIN_TAG).getAsJsonObject();
            ResourceLocation sound = new ResourceLocation(object.has(SOUND_TAG) ? object.get(SOUND_TAG).getAsString() : "item.armor.equip_generic");
            double chance = object.has(CHANCE_TAG) ? object.get(CHANCE_TAG).getAsDouble() : 1.0;
            JsonElement ids = object.get(LOOT_TABLE_TAG);
            if (ids.isJsonArray()) {
                JsonArray array = ids.getAsJsonArray();
                array.forEach(id -> DATA_MAP.put(new ResourceLocation(id.getAsString()), new Data(data.table, sound, chance)));
            } else {
                DATA_MAP.put(new ResourceLocation(ids.getAsString()), new Data(data.table, sound, chance));
            }
        }

        private boolean hasLootDefined(OnLoot.Data data) {
            ResourceLocation lootTableId = data.context.getQueriedLootTableId();
            return DATA_MAP.containsKey(lootTableId) && Random.tryChance((double)Spawn.DATA_MAP.get((Object)lootTableId).chance);
        }

        private void setCustomName(OnSpawned.Data data) {
            data.target.m_6593_(this.name.asLiteral());
        }

        private void giveRandomArmor(OnSpawned.Data data) {
            CursedArmorEntity cursedArmor = (CursedArmorEntity)data.target;
            if (cursedArmor.m_21207_() > 0.0f) {
                return;
            }
            this.equipSet((Data)Random.nextRandom(DATA_MAP).getValue(), cursedArmor, cursedArmor.m_20182_());
        }

        private void equipSet(Data data, CursedArmorEntity cursedArmor, Vec3 position) {
            LootContext lootContext = new LootContext.Builder((ServerLevel)cursedArmor.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)position).m_78972_(LootContextParams.f_81455_, (Object)cursedArmor).m_78975_(LootContextParamSets.f_81416_);
            data.lootTable.m_230922_(lootContext).forEach(arg_0 -> ((CursedArmorEntity)cursedArmor).m_255207_(arg_0));
            Arrays.stream(EquipmentSlot.values()).forEach(slot -> cursedArmor.m_21409_((EquipmentSlot)slot, this.dropChance.asFloat()));
            cursedArmor.setAssembleSound((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(data.sound));
        }

        private void startAssembling(OnSpawned.Data data) {
            CursedArmorEntity cursedArmor = (CursedArmorEntity)data.target;
            cursedArmor.startAssembling(0.0f);
        }

        private record Data(LootTable lootTable, ResourceLocation sound, double chance) {
        }
    }
}

