/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers;

import com.majruszsdifficulty.Registries;
import com.mlib.Random;
import com.mlib.config.BooleanConfig;
import com.mlib.config.EnumConfig;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ContextData;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.parameters.Priority;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public class CustomConditions {

    public static class IsNotNearUndeadArmy<DataType extends ContextData>
    extends Condition<DataType> {
        public boolean check(GameModifier gameModifier, DataType data) {
            return ((ContextData)data).entity != null && Registries.getUndeadArmyManager().findNearestUndeadArmy(((ContextData)data).entity.m_20183_()) == null;
        }
    }

    public static class IsNotUndeadArmy<DataType extends ContextData>
    extends Condition<DataType> {
        public boolean check(GameModifier gameModifier, DataType data) {
            return !Registries.getUndeadArmyManager().isPartOfUndeadArmy(((ContextData)data).entity);
        }
    }

    public static class IsNotPartOfGroup<DataType extends ContextData>
    extends Condition<DataType> {
        public IsNotPartOfGroup() {
            this.apply(params -> params.priority(Priority.HIGH));
        }

        public boolean check(GameModifier gameModifier, DataType data) {
            PathfinderMob mob;
            Entity entity = ((ContextData)data).entity;
            return entity instanceof PathfinderMob && !(mob = (PathfinderMob)entity).getPersistentData().m_128471_("MajruszsDifficultySidekick") && !mob.getPersistentData().m_128471_("MajruszsDifficultyLeader");
        }
    }

    public static class GameStageExact<DataType extends ContextData>
    extends Condition<DataType> {
        final com.majruszsdifficulty.GameStage stage;

        public GameStageExact(com.majruszsdifficulty.GameStage stage) {
            this.stage = stage;
        }

        public boolean check(GameModifier gameModifier, ContextData data) {
            return com.majruszsdifficulty.GameStage.getCurrentStage() == this.stage;
        }
    }

    public static class GameStage<DataType extends ContextData>
    extends Condition<DataType> {
        final EnumConfig<com.majruszsdifficulty.GameStage> minimumStage;

        public GameStage(com.majruszsdifficulty.GameStage minimumStage) {
            this.minimumStage = new EnumConfig((Enum)minimumStage);
            this.addConfig((IConfigurable)this.minimumStage.name("minimum_stage").comment("Minimum game stage required for that to happen."));
            this.apply(params -> params.configurable(true));
        }

        public boolean check(GameModifier gameModifier, DataType data) {
            return com.majruszsdifficulty.GameStage.atLeast((com.majruszsdifficulty.GameStage)((Object)this.minimumStage.get()));
        }
    }

    public static class CRDChance<DataType extends ContextData>
    extends Condition.Chance<DataType> {
        final BooleanConfig scaledByCRD;

        public CRDChance(double defaultChance, boolean scaledByCRD) {
            super(defaultChance);
            this.scaledByCRD = new BooleanConfig(scaledByCRD);
            this.addConfig((IConfigurable)this.scaledByCRD.name("scaled_by_crd").comment("Specifies whether the chance should be scaled by Clamped Regional Difficulty."));
        }

        public boolean check(GameModifier gameModifier, DataType data) {
            double multiplier = this.scaledByCRD.isEnabled() ? com.majruszsdifficulty.GameStage.getRegionalDifficulty(((ContextData)data).entity) : 1.0;
            return Random.tryChance((double)(multiplier * (Double)this.chance.getOrDefault()));
        }
    }
}

