/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.configs;

import com.majruszsdifficulty.goals.FollowGroupLeaderGoal;
import com.majruszsdifficulty.goals.TargetAsLeaderGoal;
import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.config.IntegerConfig;
import com.mlib.entities.EntityHelper;
import com.mlib.items.ItemHelper;
import com.mlib.loot.LootHelper;
import com.mlib.math.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MobGroupConfig
extends ConfigGroup {
    public static final String SIDEKICK_TAG = "MajruszsDifficultySidekick";
    public static final String LEADER_TAG = "MajruszsDifficultyLeader";
    static final Range<Integer> RANGE = new Range((Number)1, (Number)9);
    final Supplier<EntityType<? extends PathfinderMob>> mob;
    final IntegerConfig min;
    final IntegerConfig max;
    final ResourceLocation leaderSet;
    final ResourceLocation sidekickSet;

    public MobGroupConfig(Supplier<EntityType<? extends PathfinderMob>> mob, Range<Integer> range, ResourceLocation leaderSet, ResourceLocation sidekickSet) {
        super(new IConfigurable[0]);
        this.mob = mob;
        this.min = new IntegerConfig(((Integer)range.from).intValue(), RANGE);
        this.max = new IntegerConfig(((Integer)range.to).intValue(), RANGE);
        this.leaderSet = leaderSet;
        this.sidekickSet = sidekickSet;
        this.addConfig((IConfigurable)this.min.name("min_count").comment("Minimum amount of mobs to spawn (leader is not considered)."));
        this.addConfig((IConfigurable)this.max.name("max_count").comment("Maximum amount of mobs to spawn (leader is not considered)."));
    }

    public List<PathfinderMob> spawn(PathfinderMob leader) {
        int sidekickAmount = Random.nextInt((int)this.getMinCount(), (int)(this.getMaxCount() + 1));
        Vec3 spawnPosition = leader.m_20182_();
        ArrayList<PathfinderMob> sidekicks = new ArrayList<PathfinderMob>();
        for (int sidekickIdx = 0; sidekickIdx < sidekickAmount; ++sidekickIdx) {
            PathfinderMob sidekick = (PathfinderMob)EntityHelper.spawn(this.getMob(), (Level)leader.f_19853_, mob -> {
                this.addSidekickGoals((PathfinderMob)mob, leader);
                this.markAsSidekick((PathfinderMob)mob);
                this.applyArmorSet(this.sidekickSet, (PathfinderMob)mob);
                this.addToLevel((PathfinderMob)mob, spawnPosition);
            });
            if (sidekick == null) continue;
            sidekicks.add(sidekick);
        }
        this.markAsLeader(leader);
        this.applyArmorSet(this.leaderSet, leader);
        return sidekicks;
    }

    public EntityType<? extends PathfinderMob> getMob() {
        return this.mob.get();
    }

    public int getMinCount() {
        return Math.min((Integer)this.min.get(), (Integer)this.max.get());
    }

    public int getMaxCount() {
        return Math.max((Integer)this.min.get(), (Integer)this.max.get());
    }

    private void addSidekickGoals(PathfinderMob sidekick, PathfinderMob leader) {
        sidekick.f_21345_.m_25352_(9, (Goal)new FollowGroupLeaderGoal((Mob)sidekick, (Mob)leader, 1.0, 6.0f, 5.0f));
        sidekick.f_21346_.m_25352_(9, (Goal)new TargetAsLeaderGoal(sidekick, leader));
    }

    private void markAsSidekick(PathfinderMob sidekick) {
        sidekick.getPersistentData().m_128379_(SIDEKICK_TAG, true);
    }

    private void markAsLeader(PathfinderMob leader) {
        leader.getPersistentData().m_128379_(LEADER_TAG, true);
    }

    private void applyArmorSet(ResourceLocation location, PathfinderMob mob) {
        if (location == null) {
            return;
        }
        LootHelper.getLootTable((ResourceLocation)location).m_230922_(LootHelper.toGiftContext((Entity)mob)).forEach(itemStack -> ItemHelper.equip((Mob)mob, (ItemStack)itemStack));
        Arrays.stream(EquipmentSlot.values()).forEach(slot -> mob.m_21409_(slot, 0.05f));
    }

    private void addToLevel(PathfinderMob sidekick, Vec3 position) {
        sidekick.m_6034_(position.f_82479_ + (double)Random.nextInt((int)-3, (int)4), position.f_82480_ + 0.5, position.f_82481_ + (double)Random.nextInt((int)-3, (int)4));
        sidekick.f_19853_.m_7967_((Entity)sidekick);
    }
}

