/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.GameStageIntegerConfig;
import com.majruszsdifficulty.entities.CreeperlingEntity;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.mlib.Random;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnDeath;
import com.mlib.gamemodifiers.contexts.OnExplosion;
import com.mlib.math.Range;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.ExplosionEvent;

@AutoInstance
public class CreeperSplitIntoCreeperlings
extends GameModifier {
    final GameStageIntegerConfig creeperlingsAmount = new GameStageIntegerConfig(2, 4, 6, (Range<Integer>)new Range((Number)1, (Number)10));

    public CreeperSplitIntoCreeperlings() {
        super(Registries.Modifiers.DEFAULT);
        new OnExplosion.Context(this::spawnCreeperlings).addCondition(new CustomConditions.GameStage(GameStage.NORMAL)).addCondition(new CustomConditions.CRDChance(0.666, false)).addCondition((Condition)new Condition.Excludable()).addCondition(data -> data.explosion.getExploder() instanceof Creeper && !(data.explosion.getExploder() instanceof CreeperlingEntity)).addCondition(data -> data.event instanceof ExplosionEvent.Detonate).addConfig((IConfigurable)this.creeperlingsAmount.name("MaxCreeperlings").comment("Maximum amount of Creeperlings to spawn.")).insertTo((GameModifier)this);
        new OnExplosion.Context(this::giveAdvancement).addCondition(data -> data.explosion.getExploder() instanceof CreeperlingEntity && data.level != null).insertTo((GameModifier)this);
        new OnDeath.Context(this::giveAdvancement).addCondition(data -> data.attacker instanceof ServerPlayer).addCondition(data -> data.target instanceof CreeperlingEntity).insertTo((GameModifier)this);
        this.name("CreeperSplitIntoCreeperlings").comment("When the Creeper explode it may spawn a few Creeperlings.");
    }

    private void spawnCreeperlings(OnExplosion.Data data) {
        Creeper creeper = (Creeper)data.explosion.getExploder();
        ServerLevel level = data.level;
        int creeperlingsAmount = Random.nextInt((int)1, (int)((Integer)this.creeperlingsAmount.getCurrentGameStageValue() + 1));
        assert (creeper != null && level != null);
        for (int i = 0; i < creeperlingsAmount; ++i) {
            BlockPos position = creeper.m_20183_().m_121955_(Random.getRandomVector3i((int)-2, (int)2, (int)-1, (int)1, (int)-2, (int)2));
            CreeperlingEntity creeperling = (CreeperlingEntity)((EntityType)Registries.CREEPERLING.get()).m_262455_(level, (CompoundTag)null, null, position, MobSpawnType.SPAWNER, true, true);
            if (creeperling == null) continue;
            creeperling.m_6710_(creeper.m_5448_());
        }
    }

    private void giveAdvancement(OnExplosion.Data data) {
        assert (data.level != null);
        Vec3 position = ((ExplosionEvent)data.event).getExplosion().getPosition();
        Vec3 offset = new Vec3(10.0, 6.0, 10.0);
        List nearbyPlayers = data.level.m_45976_(ServerPlayer.class, new AABB(position.m_82546_(offset), position.m_82549_(offset)));
        nearbyPlayers.forEach(this::giveAdvancement);
    }

    private void giveAdvancement(OnDeath.Data data) {
        this.giveAdvancement((ServerPlayer)data.attacker);
    }

    private void giveAdvancement(ServerPlayer player) {
        Registries.BASIC_TRIGGER.trigger(player, "encountered_creeperling");
    }
}

