/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.mlib.Utility;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.IConfigurable;
import com.mlib.config.StringListConfig;
import com.mlib.effects.ParticleHandler;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnLoot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

@AutoInstance
public class DoubleLoot
extends GameModifier {
    static final ParticleHandler AWARD = new ParticleHandler(ParticleTypes.f_123748_, () -> new Vec3(0.5, 1.0, 0.5), () -> Float.valueOf(0.1f));
    final StringListConfig forbiddenItems = new StringListConfig(new String[]{"minecraft:nether_star", "minecraft:totem_of_undying"});

    public DoubleLoot() {
        super(Registries.Modifiers.DEFAULT);
        new OnDoubleLootContext(this::doubleLoot, 0.0, GameStage.NORMAL).name("NormalMode").comment("Determines the chance on Normal Mode.").insertTo((GameModifier)this);
        new OnDoubleLootContext(this::doubleLoot, 0.2, GameStage.EXPERT).name("ExpertMode").comment("Determines the chance on Expert Mode.").insertTo((GameModifier)this);
        new OnDoubleLootContext(this::doubleLoot, 0.4, GameStage.MASTER).name("MasterMode").comment("Determines the chance on Master Mode.").insertTo((GameModifier)this);
        this.addConfig((IConfigurable)this.forbiddenItems.name("forbidden_items").comment("List of items that cannot be duplicated."));
        this.name("DoubleLoot").comment("Gives a chance to double the loot.");
    }

    private void doubleLoot(OnLoot.Data data) {
        assert (data.entity != null && data.lastDamagePlayer != null);
        boolean doubledAtLeastOneItem = this.replaceLoot(data.generatedLoot);
        if (doubledAtLeastOneItem && data.level != null) {
            AWARD.spawn(data.level, data.entity.m_20182_().m_82520_(0.0, 0.5, 0.0), 12);
        }
    }

    private boolean replaceLoot(List<ItemStack> generatedLoot) {
        boolean doubledAtLeastOneItem = false;
        ArrayList<ItemStack> doubledLoot = new ArrayList<ItemStack>();
        for (ItemStack itemStack : generatedLoot) {
            doubledLoot.add(itemStack);
            if (!this.isAllowed(itemStack)) continue;
            doubledLoot.add(itemStack);
            doubledAtLeastOneItem = true;
        }
        generatedLoot.clear();
        generatedLoot.addAll(doubledLoot);
        return doubledAtLeastOneItem;
    }

    private boolean isAllowed(ItemStack itemStack) {
        return !itemStack.m_41619_() && !this.forbiddenItems.contains(Utility.getRegistryString((ItemStack)itemStack));
    }

    private static class OnDoubleLootContext
    extends OnLoot.Context {
        public OnDoubleLootContext(Consumer<OnLoot.Data> consumer, double chance, GameStage stage) {
            super(consumer);
            this.addCondition(new CustomConditions.GameStageExact(stage)).addCondition(new CustomConditions.CRDChance(chance, false)).addCondition(OnLoot.HAS_LAST_DAMAGE_PLAYER).addCondition(OnLoot.HAS_ENTITY);
        }
    }
}

