/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.configs.StageProgressConfig;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.BooleanConfig;
import com.mlib.config.EnumConfig;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnDeath;
import com.mlib.gamemodifiers.contexts.OnDimensionChanged;
import net.minecraft.world.entity.EntityType;

@AutoInstance
public class IncreaseGameStage
extends GameModifier {
    static final EnumConfig<GameStage> DEFAULT_GAME_STAGE = new EnumConfig((Enum)GameStage.NORMAL);
    final StageProgressConfig expertMode = new StageProgressConfig("none", "minecraft:the_nether");
    final StageProgressConfig masterMode = new StageProgressConfig("minecraft:ender_dragon", "none");
    final BooleanConfig enteringAnyDimensionStartsExpertMode = new BooleanConfig(true);

    public static GameStage getDefaultGameStage() {
        return (GameStage)((Object)DEFAULT_GAME_STAGE.get());
    }

    public IncreaseGameStage() {
        super(Registries.Modifiers.GAME_STAGE);
        new OnDimensionChanged.Context(this::startExpertMode).addCondition(data -> GameStage.getCurrentStage() == GameStage.NORMAL).addCondition(data -> this.expertMode.dimensionTriggersChange(data.to.m_135782_()) || this.enteringAnyDimensionStartsExpertMode.isEnabled()).insertTo((GameModifier)this);
        new OnDimensionChanged.Context(this::startMasterMode).addCondition(data -> GameStage.getCurrentStage() == GameStage.EXPERT).addCondition(data -> this.masterMode.dimensionTriggersChange(data.to.m_135782_())).insertTo((GameModifier)this);
        new OnDeath.Context(this::startExpertMode).addCondition(data -> GameStage.getCurrentStage() == GameStage.NORMAL).addCondition(data -> this.expertMode.entityTriggersChange(EntityType.m_20613_((EntityType)data.target.m_6095_()))).insertTo((GameModifier)this);
        new OnDeath.Context(this::startMasterMode).addCondition(data -> GameStage.getCurrentStage() == GameStage.EXPERT).addCondition(data -> this.masterMode.entityTriggersChange(EntityType.m_20613_((EntityType)data.target.m_6095_()))).insertTo((GameModifier)this);
        this.addConfig((IConfigurable)DEFAULT_GAME_STAGE.name("default_mode").comment("Game stage set at the beginning of a new world.")).addConfig((IConfigurable)this.enteringAnyDimensionStartsExpertMode.name("any_dimension_expert").comment("Determines whether any dimension should start Expert Mode (useful for integration with other mods).")).addConfig((IConfigurable)this.expertMode.name("ExpertMode").comment("Determines what starts the Expert Mode.")).addConfig((IConfigurable)this.masterMode.name("MasterMode").comment("Determines what starts the Master Mode."));
    }

    private void startExpertMode(OnDimensionChanged.Data data) {
        GameStage.changeStage(GameStage.EXPERT, data.entity.m_20194_());
    }

    private void startExpertMode(OnDeath.Data data) {
        GameStage.changeStage(GameStage.EXPERT, data.target.m_20194_());
    }

    private void startMasterMode(OnDimensionChanged.Data data) {
        GameStage.changeStage(GameStage.MASTER, data.entity.m_20194_());
    }

    private void startMasterMode(OnDeath.Data data) {
        GameStage.changeStage(GameStage.MASTER, data.target.m_20194_());
    }
}

