/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.Registries;
import com.mlib.Random;
import com.mlib.annotations.AutoInstance;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnExplosion;
import com.mlib.math.Range;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.level.ExplosionEvent;

@AutoInstance
public class PowerfulExplosions
extends GameModifier {
    final DoubleConfig radiusMultiplier = new DoubleConfig(1.2599, new Range((Number)1.0, (Number)10.0));
    final DoubleConfig fireChance = new DoubleConfig(0.75, Range.CHANCE);

    public PowerfulExplosions() {
        super(Registries.Modifiers.DEFAULT);
        new OnExplosion.Context(this::modifyExplosion).addCondition((Condition)new Condition.Excludable()).addCondition(data -> data.level != null).addCondition(data -> data.event instanceof ExplosionEvent.Start).addConfigs(new IConfigurable[]{this.radiusMultiplier.name("radius_multiplier").comment("Multiplies explosion radius by the given value (this value is scaled by Clamped Regional Difficulty).")}).addConfigs(new IConfigurable[]{this.fireChance.name("fire_chance").comment("Gives all explosions a chance to cause fire (this value is scaled by Clamped Regional Difficulty).")}).insertTo((GameModifier)this);
        this.name("PowerfulExplosions").comment("Makes all explosions (creepers, ghast ball etc.) much more deadly.");
    }

    private void modifyExplosion(OnExplosion.Data data) {
        double clampedRegionalDifficulty = GameStage.getRegionalDifficulty((Level)data.level, data.explosion.getPosition());
        double radiusMultiplier = clampedRegionalDifficulty * ((Double)this.radiusMultiplier.get() - 1.0) + 1.0;
        data.radius.setValue((Number)(radiusMultiplier * (double)data.radius.getValue().floatValue()));
        if (Random.tryChance((double)(clampedRegionalDifficulty * (Double)this.fireChance.get()))) {
            data.causesFire.setValue(true);
        }
    }
}

